/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.lexer.rules;

import fr.umlv.tatoo.runtime.lexer.rules.RegexTable;

public class DFA {
    private RegexTable table;
    private int currentState;

    public DFA() {
    }

    public DFA(RegexTable table) {
        this.reset(table);
    }

    public void reset(RegexTable table) {
        this.table = table;
        this.currentState = table.getStart();
    }

    public void reset() {
        this.currentState = this.table.getStart();
    }

    public ReturnCode step(int a) {
        this.currentState = this.table.getTransition(this.currentState, a);
        if (this.currentState == -1) {
            return ReturnCode.REJECT;
        }
        if (this.table.accept(this.currentState)) {
            if (this.table.noOut(this.currentState)) {
                return ReturnCode.FINAL_ACCEPT;
            }
            return ReturnCode.ACCEPT;
        }
        if (this.table.noOut(this.currentState)) {
            return ReturnCode.REJECT;
        }
        return ReturnCode.CONTINUE;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(this.table.getStart()).append(";");
        int length = this.table.getStateNumber();
        boolean acc = false;
        for (int i = 0; i < length; ++i) {
            if (!this.table.accept(i)) continue;
            buf.append(i).append(",");
            acc = true;
        }
        if (acc) {
            int size = buf.length();
            buf.delete(size - 1, size);
        }
        buf.append(";");
        buf.append(this.table);
        buf.append(">");
        return buf.toString();
    }

    public RegexTable getTable() {
        return this.table;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReturnCode {
        ACCEPT,
        REJECT,
        CONTINUE,
        FINAL_ACCEPT;

    }
}

