/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.lexer.rules;

import fr.umlv.tatoo.runtime.lexer.rules.DFA;
import fr.umlv.tatoo.runtime.lexer.rules.RegexTable;
import fr.umlv.tatoo.runtime.lexer.rules.RuleData;
import fr.umlv.tatoo.runtime.util.IntArrayList;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Action<R> {
    private R rule;
    private RuleData ruleData;
    private boolean hasFollowing;
    private int charNo;
    private int lastMatch;
    private boolean mainProcessFinished;
    private final DFA main;
    private final ArrayList<DFA> subProcesses = new ArrayList();
    private final IntArrayList positions = new IntArrayList();

    public Action() {
        this.main = new DFA();
    }

    public void reset(R rule, RuleData ruleData) {
        this.rule = rule;
        this.ruleData = ruleData;
        this.main.reset(ruleData.getMainRegex());
        if (this.hasFollowing) {
            this.resetProcesses();
        }
        this.charNo = 0;
        this.lastMatch = -1;
        this.mainProcessFinished = false;
        RegexTable following = ruleData.getFollowRegex();
        this.hasFollowing = following != null && !Action.containsEspilon(following);
    }

    public boolean step(int a) {
        ++this.charNo;
        if (!this.hasFollowing) {
            DFA.ReturnCode result = this.main.step(a);
            switch (result) {
                case REJECT: {
                    return false;
                }
                case FINAL_ACCEPT: {
                    this.lastMatch = this.charNo;
                    return false;
                }
                case ACCEPT: {
                    this.lastMatch = this.charNo;
                    return true;
                }
                case CONTINUE: {
                    return true;
                }
            }
            throw new InternalError("unknown process result");
        }
        block17: for (int i = 0; i < this.positions.size(); ++i) {
            DFA process = this.subProcesses.get(i);
            DFA.ReturnCode result = process.step(a);
            switch (result) {
                case REJECT: {
                    this.removeProcess(i);
                    continue block17;
                }
                case FINAL_ACCEPT: 
                case ACCEPT: {
                    this.lastMatch = Math.max(this.lastMatch, this.positions.get(i));
                    this.removeProcess(i);
                }
                case CONTINUE: {
                    continue block17;
                }
                default: {
                    throw new InternalError("unknown process result");
                }
            }
        }
        if (this.mainProcessFinished) {
            return !this.positions.isEmpty();
        }
        DFA.ReturnCode result = this.main.step(a);
        switch (result) {
            case REJECT: {
                this.mainProcessFinished = true;
                return !this.positions.isEmpty();
            }
            case FINAL_ACCEPT: {
                this.mainProcessFinished = true;
            }
            case ACCEPT: {
                this.addProcess();
                return true;
            }
            case CONTINUE: {
                return true;
            }
        }
        throw new InternalError("unknown process result");
    }

    private void removeProcess(int i) {
        int max = this.positions.size() - 1;
        if (i != max) {
            DFA tmp = this.subProcesses.get(i);
            this.subProcesses.set(i, this.subProcesses.get(max));
            this.subProcesses.set(max, tmp);
            this.positions.set(i, this.positions.get(max));
        }
        this.positions.removeLast(1);
    }

    private void addProcess() {
        int pos = this.positions.size();
        this.positions.add(this.charNo);
        if (pos < this.subProcesses.size()) {
            this.subProcesses.get(pos).reset();
        } else {
            this.subProcesses.add(new DFA(this.ruleData.getFollowRegex()));
        }
    }

    private void resetProcesses() {
        this.positions.clear();
    }

    public int lastMatch() {
        return this.lastMatch;
    }

    public R getRule() {
        return this.rule;
    }

    private static boolean containsEspilon(RegexTable table) {
        return table.accept(table.getStart());
    }
}

