/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.lexer;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.lexer.LexerTable;
import fr.umlv.tatoo.runtime.lexer.rules.ActionProcessor;
import fr.umlv.tatoo.runtime.lexer.rules.ProcessReturn;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tokenizer<R, B extends LexerBuffer> {
    final ActionProcessor<R> processor;
    B buffer;

    Tokenizer(LexerTable<R> lexerTable, B buffer) {
        this.buffer = buffer;
        this.processor = new ActionProcessor<R>(lexerTable);
    }

    public static <R, B extends LexerBuffer> Tokenizer<R, B> createTokenizer(LexerTable<R> lexerTable, B buffer) {
        return new Tokenizer<R, B>(lexerTable, buffer);
    }

    public static <R, B extends LexerBuffer> Tokenizer<R, B> createTokenizer(LexerTable<R> lexerTable, B buffer, Iterable<? extends R> blanks) {
        return new BlankSkippingTokenizer<R, B>(lexerTable, buffer, blanks);
    }

    public boolean hasNext(Iterable<? extends R> rules) throws IOException {
        boolean val = this.findNext(rules);
        this.buffer.reset();
        return val;
    }

    public boolean hasNext(R ... rules) throws IOException {
        return this.hasNext((Iterable<? extends R>)Arrays.asList(rules));
    }

    boolean findNext(Iterable<? extends R> rules) throws IOException {
        ProcessReturn ret;
        this.buffer.discard();
        while ((ret = this.processor.step((LexerBuffer)this.buffer, rules)) == ProcessReturn.MORE) {
            if (this.buffer.read()) continue;
            ret = this.processor.stepClose();
            break;
        }
        switch (ret) {
            case TOKEN: {
                return true;
            }
            case ERROR: 
            case NOTHING: {
                return false;
            }
        }
        throw new AssertionError((Object)("ActionProcessor.stepClose cannot return " + ret.name()));
    }

    public R next(Iterable<? extends R> rules) throws IOException {
        if (!this.findNext(rules)) {
            this.buffer.reset();
            throw new NoSuchElementException("no matching rules for " + rules);
        }
        this.buffer.unwind(this.processor.tokenLength());
        return this.processor.winningRule();
    }

    public R next(R ... rules) throws IOException {
        return this.next((Iterable<? extends R>)Arrays.asList(rules));
    }

    public R getNext() {
        this.buffer.unwind(this.processor.tokenLength());
        return this.processor.winningRule();
    }

    public B getBuffer() {
        return this.buffer;
    }

    public LexerTable<R> getLexerTable() {
        return this.processor.getLexerTable();
    }

    public void reset(B buffer) {
        this.buffer = buffer;
        this.processor.reset();
    }

    public boolean eof() throws IOException {
        return !this.buffer.hasRemaining() && !this.buffer.read();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlankSkippingTokenizer<R, B extends LexerBuffer>
    extends Tokenizer<R, B> {
        private final Iterable<? extends R> blanks;

        public BlankSkippingTokenizer(LexerTable<R> lexerTable, B buffer, Iterable<? extends R> blanks) {
            super(lexerTable, buffer);
            this.blanks = blanks;
        }

        @Override
        boolean findNext(Iterable<? extends R> rules) throws IOException {
            this.skipBlank();
            return super.findNext(rules);
        }

        @Override
        public boolean eof() throws IOException {
            this.skipBlank();
            return super.eof();
        }

        private void skipBlank() throws IOException {
            while (super.findNext(this.blanks)) {
                this.buffer.unwind(this.processor.tokenLength());
            }
            this.buffer.reset();
        }
    }
}

