/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.lexer;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.lexer.LexerErrorRecoveryPolicy;
import fr.umlv.tatoo.runtime.lexer.LexerListener;
import fr.umlv.tatoo.runtime.lexer.LexerTable;
import fr.umlv.tatoo.runtime.lexer.LexingException;
import fr.umlv.tatoo.runtime.lexer.LifecycleHandler;
import fr.umlv.tatoo.runtime.lexer.RuleActivator;
import fr.umlv.tatoo.runtime.lexer.SimpleLexer;
import fr.umlv.tatoo.runtime.lexer.rules.ActionProcessor;
import fr.umlv.tatoo.runtime.lexer.rules.ProcessReturn;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Lexer<B extends LexerBuffer>
implements SimpleLexer {
    final LifecycleHandler<B> lifecycleHandler;
    B buffer;

    public static <R, B extends LexerBuffer> Lexer<B> createLexer(LexerTable<R> lexerTable, B buffer, LexerListener<? super R, ? super B> listener, RuleActivator<R> activator, LifecycleHandler<B> lifecycleHandler, LexerErrorRecoveryPolicy<R, B> policy) {
        return new LexerImpl<R, B>(lexerTable, buffer, listener, activator, lifecycleHandler, policy);
    }

    Lexer(B buffer, LifecycleHandler<B> lifecycleHandler) {
        this.buffer = buffer;
        this.lifecycleHandler = lifecycleHandler;
    }

    public B getBuffer() {
        return this.buffer;
    }

    public LifecycleHandler<B> getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    public abstract void reset(B var1);

    public abstract RuleActivator<?> getActivator();

    public abstract LexerListener<?, ?> getLexerListener();

    public abstract LexerErrorRecoveryPolicy<?, ?> getLexerErrorRecoveryPolicy();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LexerImpl<R, B extends LexerBuffer>
    extends Lexer<B> {
        private final LexerListener<? super R, ? super B> listener;
        private final RuleActivator<? extends R> activator;
        private final ActionProcessor<R> processor;
        private final LexerErrorRecoveryPolicy<R, B> policy;

        LexerImpl(LexerTable<R> lexerTable, B buffer, LexerListener<? super R, ? super B> listener, RuleActivator<? extends R> activator, LifecycleHandler<B> lifecycleHandler, LexerErrorRecoveryPolicy<R, B> policy) {
            super(buffer, lifecycleHandler);
            this.listener = listener;
            this.activator = activator;
            this.policy = policy;
            this.processor = new ActionProcessor<R>(lexerTable);
        }

        @Override
        public void step() {
            while (this.buffer.hasRemaining()) {
                Iterable<? extends R> rules = this.activator.activeRules();
                ProcessReturn ret = this.policy.errorRecoveryNeedsContinuation() ? this.policy.continueRecoverOnError(this, this.processor) : this.processor.step(this.buffer, rules);
                switch (ret) {
                    case TOKEN: {
                        this.ruleVerified(this.processor.winningRule(), this.processor.tokenLength());
                        break;
                    }
                    case MORE: {
                        return;
                    }
                    case ERROR: {
                        this.policy.recoverOnError(this, this.processor);
                        break;
                    }
                    case NOTHING: {
                        throw new AssertionError((Object)"ActionProcessor.step or LexerErrorRecoveryPolicy.continueRecoverOnError can not return NOTHING");
                    }
                }
            }
        }

        @Override
        public void close() {
            while (true) {
                ProcessReturn ret = this.policy.unexpectedEndOfFileRecoveryNeedsContinuation() ? this.policy.continueRecoverOnUnexpectedEndOfFile(this, this.processor) : this.processor.stepClose();
                switch (ret) {
                    case NOTHING: {
                        if (this.lifecycleHandler != null) {
                            this.lifecycleHandler.handleClose(this);
                        }
                        return;
                    }
                    case ERROR: {
                        this.policy.recoverOnUnexpectedEndOfFile(this, this.processor);
                        break;
                    }
                    case TOKEN: {
                        this.ruleVerified(this.processor.winningRule(), this.processor.tokenLength());
                        break;
                    }
                    case MORE: {
                        throw new AssertionError((Object)"ActionProcessor.stepClose cannot return MORE");
                    }
                }
                if (!this.buffer.hasRemaining()) {
                    if (this.lifecycleHandler != null) {
                        this.lifecycleHandler.handleClose(this);
                    }
                    return;
                }
                this.step();
            }
        }

        private void ruleVerified(R rule, int lastTokenLength) {
            this.buffer.unwind(lastTokenLength);
            this.listener.ruleVerified(rule, lastTokenLength, this.buffer);
        }

        @Override
        public void run() {
            while (this.buffer.hasRemaining()) {
                this.step();
            }
            try {
                while (this.buffer.read()) {
                    this.step();
                }
                this.close();
            }
            catch (IOException e) {
                throw new LexingException(e);
            }
        }

        @Override
        public RuleActivator<? extends R> getActivator() {
            return this.activator;
        }

        @Override
        public void reset(B buffer) {
            if (this.lifecycleHandler != null) {
                this.lifecycleHandler.handleReset(this);
            }
            this.buffer = buffer;
            this.processor.reset();
        }

        @Override
        public LexerListener<? super R, ? super B> getLexerListener() {
            return this.listener;
        }

        @Override
        public LexerErrorRecoveryPolicy<R, B> getLexerErrorRecoveryPolicy() {
            return this.policy;
        }
    }
}

