/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.buffer.impl;

import fr.umlv.tatoo.runtime.buffer.TokenBuffer;
import fr.umlv.tatoo.runtime.buffer.impl.AbstractBufferWrapper;
import fr.umlv.tatoo.runtime.buffer.impl.LocationTracker;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderWrapper
extends AbstractBufferWrapper
implements TokenBuffer<CharSequence>,
CharSequence {
    private char[] buffer;
    private int limit;
    private int lexerPosition;
    private int availableTokensLimit;
    boolean newLine = true;
    private final Reader reader;
    private final int increment;
    private int availableTokensStart;
    private final int chunkSize;

    public ReaderWrapper(Reader reader, LocationTracker tracker) {
        this(1000, 100, 100, reader, tracker);
    }

    public ReaderWrapper(int capacity, int increment, int chunkSize, Reader reader, LocationTracker tracker) {
        super(tracker);
        this.reader = reader;
        this.increment = increment;
        this.chunkSize = chunkSize;
        this.buffer = new char[capacity + 1];
        this.limit = 1;
        this.lexerPosition = 1;
        this.availableTokensStart = 1;
        this.availableTokensLimit = 1;
        this.buffer[0] = 10;
    }

    @Override
    protected void unwindImpl(int l) {
        assert (l <= this.limit) : "out of bounds";
        this.availableTokensLimit += l;
        this.newLine = ReaderWrapper.isEoln(this.buffer[this.availableTokensLimit - 1]);
        this.lexerPosition = this.availableTokensLimit;
    }

    @Override
    protected void resetImpl() {
        this.lexerPosition = this.availableTokensLimit;
    }

    @Override
    public boolean previousWasNewLine() {
        return this.newLine;
    }

    @Override
    public boolean hasRemaining() {
        return this.lexerPosition != this.limit;
    }

    @Override
    public boolean read() throws IOException {
        this.ensureCapacity();
        int read = this.reader.read(this.buffer, this.limit, this.buffer.length - this.limit);
        if (read == -1) {
            return false;
        }
        this.limit += read;
        return true;
    }

    private void ensureCapacity() {
        int n = this.chunkSize;
        if (this.limit + n < this.buffer.length) {
            return;
        }
        this.clean();
        if (this.limit + n < this.buffer.length) {
            return;
        }
        char[] oldBuffer = this.buffer;
        this.buffer = new char[Math.max(oldBuffer.length + this.increment, this.limit + n)];
        System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
    }

    @Override
    protected int nextImpl() {
        if (!this.hasRemaining()) {
            throw new IllegalStateException("No remaining character in buffer, read should be called");
        }
        return this.buffer[this.lexerPosition++];
    }

    @Override
    public void discardImpl() {
        this.availableTokensStart = this.availableTokensLimit;
    }

    private void clean() {
        int l = this.availableTokensStart - 1;
        System.arraycopy(this.buffer, l, this.buffer, 0, this.limit - l);
        this.limit -= l;
        this.lexerPosition -= l;
        this.availableTokensLimit -= l;
        this.availableTokensStart = 1;
    }

    @Override
    public CharSequence view() {
        return this;
    }

    @Override
    public int length() {
        return this.availableTokensLimit - this.availableTokensStart;
    }

    @Override
    public char charAt(int index) {
        return this.buffer[this.availableTokensStart + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return CharBuffer.wrap(this.buffer, this.availableTokensStart + start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.buffer, this.availableTokensStart, this.availableTokensLimit - this.availableTokensStart);
    }

    @Override
    public int lastChar() {
        if (this.lexerPosition == 0) {
            return -1;
        }
        return this.buffer[this.lexerPosition - 1];
    }

    @Override
    protected void restartImpl() {
        this.lexerPosition = this.availableTokensStart;
        this.availableTokensLimit = this.availableTokensStart;
        this.newLine = ReaderWrapper.isEoln(this.buffer[this.lexerPosition - 1]);
    }
}

