/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.buffer.impl;

import fr.umlv.tatoo.runtime.buffer.LexerBuffer;
import fr.umlv.tatoo.runtime.buffer.TokenBuffer;
import fr.umlv.tatoo.runtime.buffer.impl.ByteProvider;
import fr.umlv.tatoo.runtime.buffer.impl.LocationTracker;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadableByteChannelWrapper
extends ByteProvider<ByteBuffer>
implements TokenBuffer<ByteBuffer>,
LexerBuffer {
    private ByteBuffer buffer;
    private ByteBuffer tokenBuffer;
    boolean newLine = true;
    private ReadableByteChannel readable;
    private final int increment;
    private final int chunkSize;

    public ReadableByteChannelWrapper(ReadableByteChannel readable, LocationTracker tracker) {
        this(true, 1000, 100, 100, readable, tracker);
    }

    public ReadableByteChannelWrapper(boolean direct, int capacity, int increment, int chunkSize, ReadableByteChannel readable, LocationTracker tracker) {
        super(tracker);
        this.readable = readable;
        this.increment = Math.max(chunkSize, increment);
        this.chunkSize = chunkSize;
        this.buffer = ReadableByteChannelWrapper.allocateBuffer(direct, capacity + 1);
        this.buffer.limit(1);
        this.buffer.put((byte)10);
        this.tokenBuffer = this.buffer.asReadOnlyBuffer();
    }

    private static ByteBuffer allocateBuffer(boolean direct, int capacity) {
        if (direct) {
            return ByteBuffer.allocateDirect(capacity);
        }
        return ByteBuffer.allocate(capacity);
    }

    @Override
    protected void resetImpl() {
        this.buffer.position(this.tokenBuffer.limit());
    }

    @Override
    protected void unwindImpl(int l) {
        int tokenLimit = this.tokenBuffer.limit() + l;
        this.tokenBuffer.limit(tokenLimit);
        this.buffer.position(tokenLimit - 1);
        byte lastChar = this.buffer.get();
        this.newLine = lastChar == 10 || lastChar == 13;
    }

    @Override
    public boolean previousWasNewLine() {
        return this.newLine;
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @Override
    public boolean read() throws IOException {
        if (this.hasRemaining()) {
            return true;
        }
        this.ensureCapacity();
        this.buffer.mark();
        int read = this.readable.read(this.buffer);
        this.buffer.limit(this.buffer.position());
        this.buffer.reset();
        return read != -1;
    }

    private void ensureCapacity() {
        int n = this.chunkSize;
        if (this.buffer.capacity() > this.buffer.position() + n) {
            this.buffer.limit(this.buffer.capacity());
            return;
        }
        int tokenStartMinusOne = this.tokenBuffer.position() - 1;
        int tokenLimit = this.tokenBuffer.limit();
        if (this.buffer.capacity() > this.buffer.position() + n - tokenStartMinusOne) {
            this.buffer.position(tokenStartMinusOne);
            this.buffer.compact();
            this.tokenBuffer.position(1);
            this.tokenBuffer.limit(tokenLimit - tokenStartMinusOne);
            return;
        }
        ByteBuffer oldBuffer = this.buffer;
        this.buffer = ReadableByteChannelWrapper.allocateBuffer(oldBuffer.isDirect(), oldBuffer.capacity() + this.increment);
        oldBuffer.position(tokenStartMinusOne);
        this.buffer.put(oldBuffer);
        this.tokenBuffer = this.buffer.asReadOnlyBuffer();
        this.tokenBuffer.position(1);
        this.tokenBuffer.limit(tokenLimit - tokenStartMinusOne);
    }

    @Override
    protected int nextImpl() {
        return this.buffer.get();
    }

    public void restart(ReadableByteChannel readableByteChannel) {
        this.readable = readableByteChannel;
        this.newLine = true;
        this.buffer.position(0).limit(0);
        this.tokenBuffer.position(0).limit(0);
        super.locationClear();
    }

    public ReadableByteChannel getReadableByteChannel() {
        return this.readable;
    }

    @Override
    protected void discardImpl() {
        this.tokenBuffer.position(this.tokenBuffer.limit());
    }

    public String toString() {
        return Charset.defaultCharset().decode(this.tokenBuffer).toString();
    }

    public String toString(String encoding) {
        CharBuffer buffer = Charset.forName(encoding).decode(this.tokenBuffer);
        return buffer.toString();
    }

    @Override
    byte getByte(int position) {
        return this.buffer.get(position);
    }

    @Override
    int limit() {
        return this.buffer.limit();
    }

    @Override
    int position() {
        return this.buffer.position();
    }

    @Override
    int tokenLimit() {
        return this.tokenBuffer.limit();
    }

    @Override
    protected void restartImpl() {
        int position = this.tokenBuffer.position();
        this.tokenBuffer.position(position - 1);
        this.newLine = ReadableByteChannelWrapper.isEoln(this.tokenBuffer.get());
        this.tokenBuffer.limit(position);
        this.buffer.position(this.tokenBuffer.position());
    }

    @Override
    public ByteBuffer view() {
        return this.tokenBuffer;
    }

    @Override
    public int lastChar() {
        if (this.buffer.position() == 0) {
            return -1;
        }
        return this.buffer.get(this.buffer.position() - 1);
    }
}

