/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.ast;

import fr.umlv.tatoo.runtime.ast.Node;
import java.util.HashMap;

public abstract class XMLNodeFactory {
    private final HashMap<String, AbstractNodeFactory> factoryMap;

    protected XMLNodeFactory(AbstractNodeFactory[] factories) {
        HashMap<String, AbstractNodeFactory> map = new HashMap<String, AbstractNodeFactory>();
        for (AbstractNodeFactory factory : factories) {
            map.put(factory.getName(), factory);
        }
        this.factoryMap = map;
    }

    Node createEmptyNode(String name) {
        AbstractNodeFactory factory = this.factoryMap.get(name);
        if (factory == null) {
            return null;
        }
        return factory.createEmptyNode();
    }

    protected static interface AbstractNodeFactory {
        public String getName();

        public Node createEmptyNode();
    }
}

