/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.ast;

import fr.umlv.tatoo.runtime.ast.AbstractNode;
import fr.umlv.tatoo.runtime.ast.Node;
import fr.umlv.tatoo.runtime.ast.XMLNodeFactory;
import fr.umlv.tatoo.runtime.util.DefaultStringConverter;
import fr.umlv.tatoo.runtime.util.StringConverter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XML {
    private XML() {
    }

    public static void serialize(Writer writer, Node node) throws IOException {
        try {
            XML.transform(node, new StreamResult(writer));
        }
        catch (TransformerConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (TransformerException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause == null) {
                cause = e;
            }
            throw (IOException)new IOException().initCause(cause);
        }
    }

    public static SAXSource createSAXSource(final Node node) {
        FakeXMLReader reader = new FakeXMLReader(){

            protected void parse() throws SAXException {
                new XMLGenerator().generateDocument(this.getContentHandler(), node);
            }
        };
        return new SAXSource(reader, new InputSource());
    }

    public static void transform(Node node, Result result) throws TransformerConfigurationException, TransformerException {
        if (result instanceof SAXResult) {
            try {
                new XMLGenerator().generateDocument(((SAXResult)result).getHandler(), node);
            }
            catch (SAXException e) {
                throw new TransformerException(e);
            }
        } else {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.newTransformer().transform(XML.createSAXSource(node), result);
        }
    }

    public static Node unserialize(Reader reader, XMLNodeFactory builder) throws IOException {
        return XML.unserialize(reader, builder, new DefaultStringConverter());
    }

    public static Node unserialize(Reader reader, XMLNodeFactory builder, StringConverter converter) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            SAXParser parser = factory.newSAXParser();
            NodeHandler handler = new NodeHandler(builder, converter);
            parser.parse(new InputSource(reader), (DefaultHandler)handler);
            return handler.root;
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (SAXException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause == null) {
                cause = e;
            }
            throw (IOException)new IOException().initCause(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StackEntry<N extends Node> {
        private int offset;
        final AbstractNode<N, ?, ?> node;

        private StackEntry(AbstractNode<N, ?, ?> node) {
            this.node = node;
        }

        void add(StackEntry<?> childEntry) {
            Node child;
            try {
                child = (Node)this.node.getElementType().cast(childEntry.node);
            }
            catch (ClassCastException e) {
                throw new ClassCastException(this.node.getElementType() + " " + childEntry.node);
            }
            this.node.nodeAt(this.offset++, child);
        }

        static <N extends Node> StackEntry<N> create(AbstractNode<N, ?, ?> node) {
            return new StackEntry<N>(node);
        }
    }

    private static class NodeHandler
    extends DefaultHandler {
        AbstractNode<?, ?, ?> root;
        private final XMLNodeFactory builder;
        private final StringConverter converter;
        private final ArrayList<StackEntry<?>> stack = new ArrayList();

        NodeHandler(XMLNodeFactory builder, StringConverter converter) {
            this.builder = builder;
            this.converter = converter;
        }

        public void startElement(String uri, String localName, String qName, Attributes xmlAttrs) throws SAXException {
            AbstractNode node = (AbstractNode)this.builder.createEmptyNode(localName);
            if (node == null) {
                throw new SAXException("invalid element name " + localName);
            }
            for (int i = 0; i < xmlAttrs.getLength(); ++i) {
                String name = xmlAttrs.getLocalName(i);
                int index = node.indexOfAttributeName(name);
                node.attributeAt(index, this.converter.convert(xmlAttrs.getValue(i), node.attributeTypeAt(index)));
            }
            this.stack.add(StackEntry.create(node));
        }

        public void endElement(String uri, String localName, String qName) {
            StackEntry<?> entry = this.stack.remove(this.stack.size() - 1);
            if (this.stack.isEmpty()) {
                this.root = entry.node;
            } else {
                StackEntry<?> parent = this.stack.get(this.stack.size() - 1);
                parent.add(entry);
            }
        }
    }

    static class XMLGenerator {
        private final AttributesImpl impl = new AttributesImpl();

        XMLGenerator() {
        }

        void generateDocument(ContentHandler handler, Node node) throws SAXException {
            handler.startDocument();
            this.generateNodes(handler, node);
            handler.endDocument();
        }

        private void generateNodes(ContentHandler handler, Node node) throws SAXException {
            this.startElement(handler, node);
            for (Node node2 : node.nodeList()) {
                this.generateNodes(handler, node2);
            }
            this.endElement(handler, node);
        }

        private void startElement(ContentHandler handler, Node node) throws SAXException {
            this.impl.clear();
            for (Map.Entry<String, ?> attributeEntry : node.attributeMap().entrySet()) {
                String name = attributeEntry.getKey();
                this.impl.addAttribute(null, name, name, "", attributeEntry.getValue().toString());
            }
            String name = node.getName();
            handler.startElement(null, name, name, this.impl);
        }

        private void endElement(ContentHandler handler, Node node) throws SAXException {
            String name = node.getName();
            handler.endElement(null, name, name);
        }
    }

    static abstract class FakeXMLReader
    implements XMLReader {
        private ContentHandler contentHandler;
        private DTDHandler dtdHandler;
        private EntityResolver entityResolver;
        private ErrorHandler errorHandler;
        private final HashSet<String> features = new HashSet();
        private final HashMap<String, Object> properties = new HashMap();

        FakeXMLReader() {
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        public void setContentHandler(ContentHandler handler) {
            this.contentHandler = handler;
        }

        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        public void setDTDHandler(DTDHandler handler) {
            this.dtdHandler = handler;
        }

        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        public void setEntityResolver(EntityResolver resolver) {
            this.entityResolver = resolver;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        public boolean getFeature(String name) {
            return this.features.contains(name);
        }

        public void setFeature(String name, boolean value) {
            if (value) {
                this.features.add(name);
            } else {
                this.features.remove(name);
            }
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        public void setProperty(String name, Object value) {
            this.properties.put(name, value);
        }

        public void parse(InputSource input) throws SAXException {
            this.parse();
        }

        public void parse(String systemId) throws SAXException {
            this.parse();
        }

        protected abstract void parse() throws SAXException;
    }
}

