/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.tatoo.runtime.ast;

import fr.umlv.tatoo.runtime.ast.Node;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNode<N extends Node, P extends Node, V>
implements Serializable,
Node {
    private static final long serialVersionUID = -4994599841088570804L;
    private P parent;
    private transient AttributeList attributeList;
    private transient AbstractMap<String, V> attributeMap;

    AbstractNode() {
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNode node = (AbstractNode)o;
        return ((Object)this.attributeList()).equals(node.attributeList()) && ((Object)this.nodeList()).equals(node.nodeList());
    }

    public int hashCode() {
        return ((Object)this.attributeList()).hashCode() ^ ((Object)this.nodeList()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append('(');
        List<V> attributes = this.attributeList();
        if (!attributes.isEmpty()) {
            for (int i = 0; i < attributes.size(); ++i) {
                builder.append(this.attributeNameAt(i)).append('=').append(attributes.get(i)).append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        for (Node node : this.nodeList()) {
            builder.append(node).append(',');
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.setLength(builder.length() - 1);
        }
        return builder.append(')').toString();
    }

    public P getParent() {
        return this.parent;
    }

    protected <T extends N> T reparent(T oldNode, T newNode) {
        if (newNode != null && newNode.getParent() != null) {
            throw new IllegalStateException("the node has already a parent");
        }
        if (oldNode != null) {
            ((AbstractNode)oldNode).parent = null;
        }
        if (newNode != null) {
            ((AbstractNode)newNode).parent = this;
        }
        return newNode;
    }

    public abstract List<N> nodeList();

    abstract boolean isFixedNodeSize();

    public void replaceAllNodes(Collection<? extends N> nodes) {
        List<N> nodeList = this.nodeList();
        if (this.isFixedNodeSize()) {
            if (nodeList.size() != nodes.size()) {
                throw new IllegalArgumentException("the number of children (" + nodeList.size() + ") of the current node and size collection (" + nodes.size() + ") is not the same");
            }
            int i = 0;
            for (Node node : nodes) {
                nodeList.set(i, node);
                ++i;
            }
        } else {
            nodeList.clear();
            nodeList.addAll(nodes);
        }
    }

    abstract N nodeAt(int var1, N var2);

    protected abstract Class<N> getElementType();

    public List<V> attributeList() {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        this.attributeList = new AttributeList();
        return this.attributeList;
    }

    protected int attributeCount() {
        return 0;
    }

    protected V attributeAt(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("invalid index " + index);
    }

    protected V attributeAt(int index, V value) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("invalid index " + index + " with value " + value);
    }

    protected String attributeNameAt(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("invalid index " + index);
    }

    protected Class<? extends V> attributeTypeAt(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("invalid index " + index);
    }

    protected int indexOfAttributeName(String name) {
        int attributeCount = this.attributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            if (!this.attributeNameAt(i).equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("invalid attribute name " + name);
    }

    public Map<String, V> attributeMap() {
        if (this.attributeMap != null) {
            return this.attributeMap;
        }
        this.attributeMap = new AbstractMap<String, V>(){
            private final Set<Map.Entry<String, V>> entrySet = new AbstractSet<Map.Entry<String, V>>(){

                @Override
                public int size() {
                    return AbstractNode.this.attributeCount();
                }

                @Override
                public Iterator<Map.Entry<String, V>> iterator() {
                    final ListIterator it = AbstractNode.this.attributeList().listIterator();
                    return new Iterator<Map.Entry<String, V>>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public Map.Entry<String, V> next() {
                            final int index = it.nextIndex();
                            return new Map.Entry<String, V>(){
                                private V value;
                                {
                                    this.value = it.next();
                                }

                                @Override
                                public String getKey() {
                                    return AbstractNode.this.attributeNameAt(index);
                                }

                                @Override
                                public V getValue() {
                                    return this.value;
                                }

                                @Override
                                public V setValue(V value) {
                                    Object oldValue = AbstractNode.this.attributeAt(index, value);
                                    this.value = value;
                                    return oldValue;
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };

            @Override
            public int size() {
                return AbstractNode.this.attributeCount();
            }

            @Override
            public Set<Map.Entry<String, V>> entrySet() {
                return this.entrySet;
            }
        };
        return this.attributeMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AttributeList
    extends AbstractList<V>
    implements RandomAccess {
        AttributeList() {
        }

        @Override
        public int size() {
            return AbstractNode.this.attributeCount();
        }

        @Override
        public V get(int index) {
            return AbstractNode.this.attributeAt(index);
        }

        @Override
        public V set(int index, V element) {
            return AbstractNode.this.attributeAt(index, element);
        }
    }
}

