from distutils.core import setup, Extension
import os, os.path, re


include_dirs = []
library_dirs = []
libraries = []

def getProcessLine(cmd):
    "Get the output of a command "
    sin, sout, serr = os.popen3(cmd)
    sin.close()
    serr.close()
    l = str(sout.readline())
    sout.close()
    return l


curentpath = os.getcwd()
cpp_src_path = os.path.abspath("../../src/c++")

re_libs = re.compile(r'-l(\S+)')
re_inc = re.compile(r'-I(\S+)')



# --------------------------- Settings libraries and include paths


# -- Boost & iucc --
# FIXME: should be parameters
library_dirs.append('/local/bpiwowar/usr/lib')
include_dirs.append('/local/bpiwowar/usr/include/boost-1_33_1')
libraries.extend(["icuuc","boost_filesystem-gcc"])


# -- libxml2 --
libraries.extend(re_libs.findall(getProcessLine("pkg-config --libs libxml-2.0")))
include_dirs.extend(re_inc.findall(getProcessLine("pkg-config --cflags libxml-2.0")))


# -- Outilex & systran --

include_dirs.extend([os.path.join(cpp_src_path, 'igm', s) for s in ("XML","unicode","dic-utils","tok2fsa","text","utils","lingdef","FSA","wrtn")])
include_dirs.append(os.path.join(cpp_src_path,'systran/tokenization'))
 
library_dirs.extend([os.path.join(cpp_src_path,'systran/tokenization'), os.path.join(cpp_src_path,'igm/lib')])
libraries = ["tokenization", "odico", "otext", "olingdef", "oxml", "ortn" ] + libraries


# --------------------------- Setup part

module1 = Extension('outilex',
                    define_macros = [('MAJOR_VERSION', '1'), ('MINOR_VERSION', '0')],
                    include_dirs = include_dirs,
                    library_dirs = library_dirs,
                    libraries =  libraries,
                    sources = ['outilex.cpp', 'token.cpp'])

setup (name = 'outilex',
       version = '1.0',
       description = 'This is an interface for some outilex/systran libraries',
       author = 'Benjamin Piwowarski',
       author_email = 'bpiwowar@dcc.uchile.cl',
       ext_modules = [module1])
