#include <stdlib.h>

#include "htmltype.h"

// When a string is added in 5th column the string should be added in
// typo_properties::list_properties too

static const tagdef TagDef[]= // MUST BE SORTED ! (use of bsearch)
// ELEMENT NAME,  TYPE         SEGTAG    BLOCKLEVEL     PROPERTY
{
 {"A"		,TYPESETTAG	,0	,TYPESET,       "link"},
 {"ABBR"	,TYPESETTAG	,0	,TYPESET,	0},
 {"ACRONYM"	,TYPESETTAG	,0	,TYPESET,	0},
 {"ADDRESS"	,SKIPTAG	,0	,TYPESET,	0},
 {"APPLET"	,SKIPTAG	,0	,TOPLEVEL,	0},
 {"AREA"	,LOWLEVELTAG	,0	,TYPESET,	0},
 {"B"		,TYPESETTAG	,0	,TYPESET,	"bold"},
 {"BASE"	,SIMPLETAG	,1	,NOCLOSE,	0},
 {"BASEFONT"	,TYPESETTAG	,0	,NOCLOSE,	0},
 {"BDO"		,TYPESETTAG	,0	,TYPESET,	0},
 {"BIG"		,TYPESETTAG	,0	,TYPESET,	0},
 {"BKD"		,TYPESETTAG	,0	,TYPESET,	0},
 {"BLOCKQUOTE"	,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"BODY"	,TOPLEVELTAG	,1	,TOPLEVEL,	0},
 {"BR"		,SINGLETAG	,1	,NOCLOSE,	0},
 {"BUTTON"      ,TABLETAG       ,1      ,TABLE,         0},
 {"CAPTION"	,TABLETAG	,1	,TABLE,	        0},
 {"CENTER"	,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"CITE"	,TYPESETTAG	,0	,TYPESET,	0},
 {"CODE"	,SKIPTAG	,0	,TYPESET,	0},
 {"COL"		,TABLETAG	,1	,TABLE,	        0},
 {"COLGROUP"	,TABLETAG	,1	,TABLE,	        0},
 {"DD"		,LISTTAG	,1	,TABLE,	        0},
 {"DEL"		,SKIPTAG	,0	,TYPESET,	0},
 {"DFN"		,TYPESETTAG	,0	,TYPESET,	0},
 {"DIR"		,LISTTAG	,1	,TABLE,	        0},
 {"DIV"		,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"DL"		,LISTTAG	,1	,TABLE,	        0},
 {"DT"		,LISTTAG	,1	,TABLE,	        0},
 {"EM"		,TYPESETTAG	,0	,TYPESET,	"italic"},
 {"FONT"	,TYPESETTAG	,0	,TYPESET,	"font_id"},
 {"FORM"	,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"FRAME"	,SIMPLETAG	,1	,NOCLOSE,	0},
 {"FRAMESET"	,TOPLEVELTAG	,1	,TOPLEVEL,	0},
 {"H1"		,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"H2"		,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"H3"		,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"H4"		,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"H5"		,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"H6"		,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"HEAD"	,TOPLEVELTAG	,1	,TOPLEVEL,	0},
 {"HR"		,SINGLETAG	,1	,NOCLOSE,	0},
 {"HTML"	,TOPLEVELTAG	,1	,TOPLEVEL,	0},
 {"I"		,TYPESETTAG	,0	,TYPESET,	"italic"},
 {"IFRAME"	,SIMPLETAG	,1	,NOCLOSE,	0},
 {"ILAYER"	,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"IMG"		,INSETTAG	,0	,NOCLOSE,	0},
 {"INPUT"	,SIMPLETAG	,1	,NOCLOSE,	0},
 {"INS"		,TYPESETTAG	,0	,TYPESET,	0},
 {"ISINDEX"	,SIMPLETAG	,1	,NOCLOSE,	0},
 {"LAYER"	,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"LI"		,LOWLEVELTAG	,1	,TYPESET,	0},
 {"LINK"	,SIMPLETAG	,1	,NOCLOSE,	0},
 {"MAP"		,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"MENU"	,LISTTAG	,1	,TABLE,	        0},
 {"META"	,METATAG        ,0	,NOCLOSE,	0},
 {"NOBR"	,LOWLEVELTAG	,0	,TYPESET,       0},
 {"NOFRAMES"	,TOPLEVELTAG	,1	,TOPLEVEL,	0},
 {"NOLAYER"	,BLOCKLEVELTAG	,1	,BLOCKLEVEL,	0},
 {"NOSCRIPT"	,SKIPTAG	,0	,TOPLEVEL,	0},
 {"OL"		,LISTTAG	,1	,TABLE,	        0},
 {"OPTION"	,NOTYPESETTAG	,1	,TABLE,	        0},
 {"P"		,LOWLEVELTAG	,1	,TYPESET,	0},
 {"PRE"		,BLOCKMODIFIERTAG,0	,TYPESET,	0},
 {"Q"		,TYPESETTAG	,0	,TYPESET,	0},
 {"S"		,TYPESETTAG	,0	,TYPESET,	0},
 {"SAMP"	,SKIPTAG	,0	,TYPESET,	0},
 {"SCRIPT"	,SKIPTAG	,0	,TOPLEVEL,	0},
 {"SELECT"	,LISTTAG	,1	,TABLE,	        0},
 {"SMALL"	,TYPESETTAG	,0	,TYPESET,	0},
 {"SPAN"	,TYPESETTAG	,0	,TYPESET,	0},
 {"STRIKE"	,TYPESETTAG	,0	,TYPESET,	0},
 {"STRONG"	,TYPESETTAG	,0	,TYPESET,	"bold"},
 {"STYLE"	,SKIPTAG	,0	,TOPLEVEL,	0},
 {"SUB"		,TYPESETTAG	,0	,TYPESET,	0},
 {"SUP"		,TYPESETTAG	,0	,TYPESET,	"sup"},
 {"TABLE"	,TABLETAG	,1	,TABLE,	        0},
 {"TBODY"	,TABLETAG	,1	,TABLE,	        0},
 {"TD"		,TABLETAG	,1	,TABLE,	        0},
 {"TEXTAREA"    ,NOTYPESETTAG       ,1      ,TABLE,         0},
 {"TFOOT"	,TABLETAG	,1	,TABLE,	        0},
 {"TH"		,TABLETAG	,1	,TABLE,	        0},
 {"THEAD"	,TABLETAG	,1	,TABLE,	        0},
 {"TITLE"	,NOTYPESETTAG	,1	,BLOCKLEVEL,	0},
 {"TR"		,TABLETAG	,1	,TABLE,	        0},
 {"TT"		,TYPESETTAG	,0	,TYPESET,	0},
 {"U"		,TYPESETTAG	,0	,TYPESET,	"underline"},
 {"UL"		,LISTTAG	,1	,TABLE,	        0},
 {"VAR"		,SKIPTAG	,0	,TYPESET,       0},
 {"WBR"		,LOWLEVELTAG	,0	,NOCLOSE,       0},
};

const int nTagDef=sizeof(TagDef)/sizeof(tagdef);

int cmpnametag(const void *td1,const void *td2)
{
  return strcasecmp( ((tagdef*)td1)->nametag, ((tagdef*)td2)->nametag);
}

int findTag(const char *s,tagdef &t) {
  tagdef t1;
  t1.nametag=s;
  void *b=bsearch(&t1,TagDef,nTagDef,sizeof(tagdef),cmpnametag);
  if (!b) return 0;
  t=*(tagdef*)b;
  return 1;
}

static entitydef EntityDef[]= // MUST BE SORTED! (use of bsearch)
{
 {		"AElig"		,"Æ"},
 {		"Aacute"	,"Á"},
 {		"Acirc"		,"Â"},
 {		"Agrave"	,"À"},
 {		"Alpha"		,"\x91"},
 {		"Aring"		,"Å"},
 {		"Atilde"	,"Ã"},
 {		"Auml"		,"Ä"},
 {		"Beta"		,"\x92"},
 {		"Ccedil"	,"Ç"},
 {		"Chi"		,"Χ"},
 {		"Dagger"	,"\x80"},
 {		"Delta"		,"\x94"},
 {		"ETH"		,"Ð"},
 {		"Eacute"	,"É"},
 {		"Ecirc"		,"Ê"},
 {		"Egrave"	,"È"},
 {		"Epsilon"	,"\x95"},
 {		"Eta"		,"\x97"},
 {		"Euml"		,"Ë"},
 {		"Gamma"		,"\x93"},
 {		"Iacute"	,"Í"},
 {		"Icirc"		,"Î"},
 {		"Igrave"	,"Ì"},
 {		"Iota"		,"\x99"},
 {		"Iuml"		,"Ï"},
 {		"Kappa"		,"\x9a"},
 {		"Lambda"	,"\x9b"},
 {		"Mu"		,"\x9c"},
 {		"Ntilde"	,"Ñ"},
 {		"Nu"		,"\x9d"},
 {		"OElig"		,"\x92"},
 {		"Oacute"	,"Ó"},
 {		"Ocirc"		,"Ô"},
 {		"Ograve"	,"Ò"},
 {		"Omega"		,"Ω"},
 {		"Omicron"	,"\x9f"},
 {		"Oslash"	,"Ø"},
 {		"Otilde"	,"Õ"},
 {		"Ouml"		,"Ö"},
 {		"Phi"		,"Φ"},
 {		"Pi"		,"Π"},
 {		"Prime"		,"\x80"},
 {		"Psi"		,"Ψ"},
 {		"Rho"		,"Ρ"},
 {		"Scaron"	,"Š"},
 {		"Sigma"		,"Σ"},
 {		"THORN"		,"Þ"},
 {		"Tau"		,"Τ"},
 {		"Theta"		,"\x98"},
 {		"Uacute"	,"Ú"},
 {		"Ucirc"		,"Û"},
 {		"Ugrave"	,"Ù"},
 {		"Upsilon"	,"Υ"},
 {		"Uuml"		,"Ü"},
 {		"Xi"		,"\x9e"},
 {		"Yacute"	,"Ý"},
 {		"Yuml"		,"Ÿ"},
 {		"Zeta"		,"\x96"},
 {		"aacute"	,"á"},
 {		"acirc"		,"â"},
 {		"acute"		,"´"},
 {		"aelig"		,"æ"},
 {		"agrave"	,"à"},
 {		"alefsym"	,"\x84"},
 {		"alpha"		,"α"},
 {		"amp"		,"&"},
 {		"and"		,"\x88"},
 {		"ang"		,"\x88"},
 {              "apos"          ,"'"},
 {		"aring"		,"å"},
 {		"asymp"		,"\x89\x88"},
 {		"atilde"	,"ã"},
 {		"auml"		,"ä"},
 {		"bdquo"		,"\x80\x9e"},
 {		"beta"		,"β"},
 {		"brvbar"	,"¦"},
 {		"bull"		,"\x80"},
 {		"cap"		,"\x88"},
 {		"ccedil"	,"ç"},
 {		"cedil"		,"¸"},
 {		"cent"		,"¢"},
 {		"chi"		,"\x87"},
 {		"circ"		,"\x86"},
 {		"clubs"		,"\x99"},
 {		"cong"		,"\x89\x85"},
 {		"copy"		,"©"},
 {		"crarr"		,"\x86"},
 {		"cup"		,"\x88"},
 {		"curren"	,"¤"},
 {		"dArr"		,"\x87\x93"},
 {		"dagger"	,"\x80"},
 {		"darr"		,"\x86\x93"},
 {		"deg"		,"°"},
 {		"delta"		,"δ"},
 {		"diams"		,"\x99"},
 {		"divide"	,"÷"},
 {		"eacute"	,"é"},
 {		"ecirc"		,"ê"},
 {		"egrave"	,"è"},
 {		"empty"		,"\x88\x85"},
 {		"emsp"		,"\x80\x83"},
 {		"ensp"		,"\x80\x82"},
 {		"epsilon"	,"ε"},
 {		"equiv"		,"\x89"},
 {		"eta"		,"η"},
 {		"eth"		,"ð"},
 {		"euml"		,"ë"},
 {		"euro"		,"\x82"},
 {		"exist"		,"\x88\x83"},
 {		"fnof"		,"\x92"},
 {		"forall"	,"\x88\x80"},
 {		"frac12"	,"½"},
 {		"frac14"	,"¼"},
 {		"frac34"	,"¾"},
 {		"frasl"		,"\x81\x84"},
 {		"gamma"		,"γ"},
 {		"ge"		,"\x89"},
 {		"gt"		,">"},
 {		"hArr"		,"\x87\x94"},
 {		"harr"		,"\x86\x94"},
 {		"hearts"	,"\x99"},
 {		"hellip"	,"\x80"},
 {		"iacute"	,"í"},
 {		"icirc"		,"î"},
 {		"iexcl"		,"¡"},
 {		"igrave"	,"ì"},
 {		"image"		,"\x84\x91"},
 {		"infin"		,"\x88\x9e"},
 {		"int"		,"\x88"},
 {		"iota"		,"ι"},
 {		"iquest"	,"¿"},
 {		"isin"		,"\x88\x88"},
 {		"iuml"		,"ï"},
 {		"kappa"		,"κ"},
 {		"lArr"		,"\x87\x90"},
 {		"lambda"	,"λ"},
 {		"lang"		,"\x8c"},
 {		"laquo"		,"«"},
 {		"larr"		,"\x86\x90"},
 {		"lceil"		,"\x8c\x88"},
 {		"ldquo"		,"\x80\x9c"},
 {		"le"		,"\x89"},
 {		"lfloor"	,"\x8c\x8a"},
 {		"lowast"	,"\x88\x97"},
 {		"loz"		,"\x97\x8a"},
 {		"lrm"		,"\x80\x8e"},
 {		"lsaquo"	,"\x80"},
 {		"lsquo"		,"\x80\x98"},
 {		"lt"		,"<"},
 {		"macr"		,"¯"},
 {		"mdash"		,"\x80\x94"},
 {		"micro"		,"µ"},
 {		"middot"	,"·"},
 {		"minus"		,"\x88\x92"},
 {		"mu"		,"μ"},
 {		"nabla"		,"\x88\x87"},
 {		"nbsp"		," "},
 {		"ndash"		,"\x80\x93"},
 {		"ne"		,"\x89"},
 {		"ni"		,"\x88\x8b"},
 {		"not"		,"¬"},
 {		"notin"		,"\x88\x89"},
 {		"nsub"		,"\x8a\x84"},
 {		"ntilde"	,"ñ"},
 {		"nu"		,"ν"},
 {		"oacute"	,"ó"},
 {		"ocirc"		,"ô"},
 {		"oelig"		,"\x93"},
 {		"ograve"	,"ò"},
 {		"oline"		,"\x80"},
 {		"omega"		,"\x89"},
 {		"omicron"	,"ο"},
 {		"oplus"		,"\x8a\x95"},
 {		"or"		,"\x88"},
 {		"ordf"		,"ª"},
 {		"ordm"		,"º"},
 {		"oslash"	,"ø"},
 {		"otilde"	,"õ"},
 {		"otimes"	,"\x8a\x97"},
 {		"ouml"		,"ö"},
 {		"para"		,"¶"},
 {		"part"		,"\x88\x82"},
 {		"permil"	,"\x80"},
 {		"perp"		,"\x8a"},
 {		"phi"		,"\x86"},
 {		"pi"		,"\x80"},
 {		"piv"		,"\x96"},
 {		"plusmn"	,"±"},
 {		"pound"		,"£"},
 {		"prime"		,"\x80"},
 {		"prod"		,"\x88\x8f"},
 {		"prop"		,"\x88\x9d"},
 {		"psi"		,"\x88"},
 {		"quot"		,"\""},
 {		"rArr"		,"\x87\x92"},
 {		"radic"		,"\x88\x9a"},
 {		"rang"		,"\x8c"},
 {		"raquo"		,"»"},
 {		"rarr"		,"\x86\x92"},
 {		"rceil"		,"\x8c\x89"},
 {		"rdquo"		,"\x80\x9d"},
 {		"real"		,"\x84\x9c"},
 {		"reg"		,"®"},
 {		"rfloor"	,"\x8c\x8b"},
 {		"rho"		,"\x81"},
 {		"rlm"		,"\x80\x8f"},
 {		"rsaquo"	,"\x80"},
 {		"rsquo"		,"\x80\x99"},
 {		"sbquo"		,"\x80\x9a"},
 {		"scaron"	,"š"},
 {		"sdot"		,"\x8b\x85"},
 {		"sect"		,"§"},
 {		"shy"		,"­"},
 {		"sigma"		,"\x83"},
 {		"sigmaf"	,"\x82"},
 {		"sim"		,"\x88"},
 {		"spades"	,"\x99"},
 {		"sub"		,"\x8a\x82"},
 {		"sube"		,"\x8a\x86"},
 {		"sum"		,"\x88\x91"},
 {		"sup"		,"\x8a\x83"},
 {		"sup1"		,"¹"},
 {		"sup2"		,"²"},
 {		"sup3"		,"³"},
 {		"supe"		,"\x8a\x87"},
 {		"szlig"		,"ß"},
 {		"tau"		,"\x84"},
 {		"there4"	,"\x88"},
 {		"theta"		,"θ"},
 {		"thetasym"	,"\x91"},
 {		"thinsp"	,"\x80\x89"},
 {		"thorn"		,"þ"},
 {		"tilde"		,"\x9c"},
 {		"times"		,"×"},
 {		"trade"		,"\x84"},
 {		"uArr"		,"\x87\x91"},
 {		"uacute"	,"ú"},
 {		"uarr"		,"\x86\x91"},
 {		"ucirc"		,"û"},
 {		"ugrave"	,"ù"},
 {		"uml"		,"¨"},
 {		"upsih"		,"\x92"},
 {		"upsilon"	,"\x85"},
 {		"uuml"		,"ü"},
 {		"weierp"	,"\x84\x98"},
 {		"xi"		,"ξ"},
 {		"yacute"	,"ý"},
 {		"yen"		,"¥"},
 {		"yuml"		,"ÿ"},
 {		"zeta"		,"ζ"},
 {		"zwj"		,"\x80\x8d"},
 {		"zwnj"		,"\x80\x8c"},
};

const int nEntityDef=sizeof(EntityDef)/sizeof(entitydef);

int cmpnameentity(const void *ed1,const void *ed2)
{
  return strcmp( ((entitydef*)ed1)->nameentity, ((entitydef*)ed2)->nameentity);
}

int findEntity(const char *s,entitydef &t) {
  entitydef t1;
  t1.nameentity=s;
  void *b=bsearch(&t1,EntityDef,nEntityDef,sizeof(entitydef),cmpnameentity);
  if (!b) return 0;
  t=*(entitydef*)b;
  return 1;
}
