#ifndef _UNICODEDATA_H_
#define _UNICODEDATA_H_

#include <stdio.h>

#define isletter(c) (c==gc_Lu || c==gc_Ll || c==gc_Lt || c==gc_Lm || c==gc_Lo || c==gc_Mn)
#define issymbol(c) (c>=gc_Sm && c<=gc_So)
#define ispunctuation(c) (c>=gc_Pc && c<=gc_Po)
#define UnicodeData_isnumber(c) (c>=gc_Nd && c<=gc_No)
#define isseparator(c) (c>=gc_Zs && c<=gc_Zp)

#define uCodePage(u) (((punidata)u>=ud_ref_end)?(punidata)u-ud_ref_end:((punidata)u)->CodePage)
#define uGeneralCategory(u) (((punidata)u>=ud_ref_end)?gc_Lo:((punidata)u)->GeneralCategory)
#define uFamily(u) (((punidata)u>=ud_ref_end)?f_CJKV:((punidata)u)->Family)
#define uCharacterDecompositionMapping(u) (((punidata)u>=ud_ref_end)?NULL:((punidata)u)->CharacterDecompositionMapping)
#define uUppercaseMapping(u) (((punidata)u>=ud_ref_end)?0x0:((punidata)u)->UppercaseMapping)
#define uLowercaseMapping(u) (((punidata)u>=ud_ref_end)?0x0:((punidata)u)->LowercaseMapping)

typedef enum gc_val { 
  gc_undef=-1,  /* no definition -1 */
  gc_Lu, /* Letter, Uppercase - 0   */
  gc_Ll, /* Letter, Lowercase - 1   */
  gc_Lt, /* Letter, Titlecase - 2   */
  gc_Lm, /* Letter, Modifier  - 3   */
  gc_Lo, /* Letter, Other     - 4   */
  gc_Mn, /* Mark, Non-Spacing - 5   */
  gc_Mc, /* Mark, Spacing Combining - 6 */
  gc_Me, /* Mark, Enclosing   - 7   */
  gc_Nd, /* Number, DecimalDigit - 8 */
  gc_Nl, /* Number, Letter       - 9 */
  gc_No, /* Number, Other        -10 */
  gc_Pc, /* Punctuation, Connector11*/
  gc_Pd, /* Punctuation, Dash    -12*/
  gc_Ps, /* Punctuation, Open    -13*/
  gc_Pe, /* Punctuation, Close   -14*/
  gc_Pi, /* Punctuation, Initial quote -15 */
  gc_Pf, /* Punctuation, Final quote -16 */
  gc_Po, /* Punctuation, Other -17 */
  gc_Sm, /* Symbol, Math       -18 */
  gc_Sc, /* Symbol, Currency   -19 */
  gc_Sk, /* Symbol, Modifier   -20 */
  gc_So, /* Symbol, Other      -21 */
  gc_Zs, /* Separator, Space   -22 */
  gc_Zl, /* Separator, Line    -23 */
  gc_Zp, /* Separator, Paragraph -24 */
  gc_Cc, /* Other, Control       -25 */
  gc_Cf, /* Other, Format        -26 */
  gc_Cs, /* Other, Surrogate     -27 */
  gc_Co, /* Other, Private Use   -28 */
  gc_Cn  /* Other, No Assigned   -29 */
} gc_val;

static const char *gc_s[]={
  "Lu", /* Letter, Uppercase - 0   */
  "Ll", /* Letter, Lowercase - 1   */
  "Lt", /* Letter, Titlecase - 2   */
  "Lm", /* Letter, Modifier  - 3   */
  "Lo", /* Letter, Other     - 4   */
  "Mn", /* Mark, Non-Spacing - 5   */
  "Mc", /* Mark, Spacing Combining - 6 */
  "Me", /* Mark, Enclosing   - 7   */
  "Nd", /* Number, DecimalDigit - 8 */
  "Nl", /* Number, Letter       - 9 */
  "No", /* Number, Other        -10 */
  "Pc", /* Punctuation, Connector11*/
  "Pd", /* Punctuation, Dash    -12*/
  "Ps", /* Punctuation, Open    -13*/
  "Pe", /* Punctuation, Close   -14*/
  "Pi", /* Punctuation, Initial quote -15 */
  "Pf", /* Punctuation, Final quote -16 */
  "Po", /* Punctuation, Other -17 */
  "Sm", /* Symbol, Math       -18 */
  "Sc", /* Symbol, Currency   -19 */
  "Sk", /* Symbol, Modifier   -20 */
  "So", /* Symbol, Other      -21 */
  "Zs", /* Separator, Space   -22 */
  "Zl", /* Separator, Line    -23 */
  "Zp", /* Separator, Paragraph -24 */
  "Cc", /* Other, Control       -25 */
  "Cf", /* Other, Format        -26 */
  "Cs", /* Other, Surrogate     -27 */
  "Co", /* Other, Private Use   -28 */
  "Cn"  /* Other, No Assigned   -29 */
};

typedef enum bc_val {
  bc_L,   // Left-to-Right
  bc_LRE, // Left-to-Right Embedding
  bc_LRO, // Left-to-Right Override
  bc_R,   // Right-to-Left
  bc_AL,  // Right-to-Left Arabic
  bc_RLE, // Right-to-Left Embedding
  bc_RLO, // Right-to-Left Override
  bc_PDF, // Pop Directional Formal
  bc_EN,  // European Number
  bc_ES,  // European Number Separator
  bc_ET,  // European Number Terminator
  bc_AN,  // Arabic Number
  bc_CS,  // Common Number Separator
  bc_NSM, // Non-Spacing Mark
  bc_BN,  // Boundary Neutral
  bc_B,   // Paragraph Separator
  bc_S,   // Segment Separator
  bc_WS,  // Whitespace
  bc_ON   // Other Neutrals
} bc_val;

typedef enum m_val {
  m_Y, // Mirrored
  m_N  // Not Mirrored
} m_val;

typedef enum t_cdm {
  t_font,      // <font>     A font variant
  t_noBreak,   // <noBreak>  A no-break version of a space of hyphen
  t_initial,   // <initial>  An initial presentation form (Arabic)
  t_medial,    // <medial>   A medial presentation form (Arabic)
  t_final,     // <final>    A final presentation form (Arabic)
  t_isolated,  // <isolated> An isolated presentation form (Arabic)
  t_circle,    // <circle>   An encircled form
  t_super,     // <super>    A superscript form
  t_sub,       // <sub>      A subscript form
  t_vertical,  // <vertical> A vertical layout presentation form
  t_wide,      // <wide>     A wide (or zenkaku) compatibility character
  t_narrow,    // <narrow>   A narrow (or hankaky) compatibility character
  t_small,     // <small>    A small variant form
  t_square,    // <square>   A CJK squared font variant
  t_fraction,  // <fraction> A vulgar fraction form
  t_compat     // <compat>   Otherwise unspecified compatibility character
} t_cdm;

typedef enum f_val { f_na,f_undef,f_LATIN,f_GREEK,f_CYRILLIC,f_ARABIC,f_CJKV } f_val;

static char *f_s[]={ "na","undef","latin","greek","cyrillic","arabic","cjkv",NULL };

struct unidata {
  unsigned short   CodePage;
#ifdef DEBUGUNI
  char *        CharacterName;
#endif
  /* WARNING! Here, 4 and 6 bits should be enough, but there seems to
   * be a bug in MSVC++ 6 in which field bits are sometimes signed,
   * sometimes unsigned(!), so we prudently do not use the higher bit */
  f_val         Family:4;
  gc_val        GeneralCategory:7;
#ifdef DEBUGUNI
  int           CanonicalCombiningClasses;
  bc_val        BiDiCategory;
#endif
  char *        CharacterDecompositionMapping;
#ifdef DEBUGUNI
  int           DecimalDigitValue;
  int           DigitValue;
  int           NumericValue;
  m_val         Mirrored;
  char *        Unicode10Name;
  char *        CommentField10646;
#endif
  unsigned short           UppercaseMapping;
  unsigned short           LowercaseMapping;
#ifdef DEBUGUNI
  int           TitlecaseMapping;
#endif
};

extern struct unidata ud_ref[];
extern int size_ud_ref;

extern "C" struct unidata *ud_ref_end;

typedef void unirdata;
typedef struct unidata *punidata;

#endif //_UNICODEDATA_H_
