
#include "DocFilters.h"
#include "ParseTXT.h"

#define FILTER_TEXT_LINE_LENGTH 150
int max_line_length;

DocumentPtr PreFilterTXT(DocumentPtr Doc) {

  xmlNodePtr root = xmlDocGetRootElement(Doc->xmltree);

  while (root && root->type != XML_ELEMENT_NODE)
    root = root->next;
  if (!root) {
    fprintf(stderr,"Error in internal filter (2)\n");
    return 0;
  }

  xmlNewProp(root, (const xmlChar *)"original_format", (const xmlChar *)"txt");

  // Checking wrap

  bool is_wrapped = false;

  const char *p = Doc->buffer.c_str();
  is_wrapped = true;
  max_line_length = 0;
    
  while (*p) {
    int line_length = 0;
      
    do {
      size_t len = strlen(p);//utf8charlen(p);
      line_length += len;
      p += len;
    } while (*p && *p!='\n' && *p!='\r');
    if (line_length > max_line_length)
      max_line_length = line_length;
    if(line_length > FILTER_TEXT_LINE_LENGTH) {
      is_wrapped = false;
      break;
    }
  }

  int ec;

  if ((ec = ecTxtParse(root,Doc->buffer.c_str(),is_wrapped)) != ecOK) {
    if (ec != ecABORTED) fprintf(stderr,"Error during txt parsing\n");
    delete Doc;
    return NULL;
    }

  return Doc;
}
