#include <string.h>
#include <stdlib.h>

#include "EncodingIANA.h"
//#include "portable.h"
//#include "Case.h"

typedef const char* struct_iana[3];

// Charset definition from http://www.iana.org/assignments/character-sets

/* This subset is extracted form the IANA defined charsets and their aliases */
/* 3 columns are: alias name, reference iana name, cnv table associated */

static struct_iana const refIANA[]= {
   { "866","IBM866","altvar" },
   { "8859-1","ISO-8859-1","8859-1" },
   { "8859-2","ISO-8859-2","8859-2" },
   { "8859-3","ISO-8859-3","8859-3" },
   { "8859-4","ISO-8859-4","8859-4" },
   { "8859-5","ISO-8859-5","8859-5" },
   { "8859-6","ISO-8859-6","8859-6" },
   { "8859-7","ISO-8859-7","8859-7" },
   { "8859-8","ISO-8859-8","8859-8" },
   { "arabic","ISO-8859-6","8859-6" },
   { "ASMO-708","ISO-8859-6","8859-6" },
   { "Big-5","BIG5","big5" },
   { "Big5","BIG5","big5" },
   { "chinese","GB_2312-80","gb2312" },
   { "cp866","IBM866","altvar" },
   { "csBig5","BIG5","big5" },
   { "csEUCPkdFmtJapanese","EUC-JP","ejis208"},
   { "csISOLatin1","ISO-8859-1","8859-1" },
   { "csISOLatin2","ISO-8859-2","8859-2" },
   { "csISOLatin3","ISO-8859-3","8859-3" },
   { "csISOLatin4","ISO-8859-4","8859-4" },
   { "csISOLatin5","ISO-8859-9","8859-5" },
   { "csISOLatinArabic","ISO-8859-6","8859-6" },
   { "csISOLatinCyrillic","ISO-8859-5","8859-5" },
   { "csISOLatinGreek","ISO-8859-7","8859-7" },
   { "csISOLatinHebrew","ISO-8859-8","8859-8" },
   { "csJISEncoding","JIS_ENCODING","jis0212" },
   { "csKOI8R","KOI8-R","koi8r" },
   { "csKSC5636","CP949","ksc" },
   { "csShiftJIS","SHIFT_JIS","shiftjis" },
   { "cyrillic","ISO-8859-5","8859-5" },
   { "EGB2312","GB2312","gb2312" },
   { "EUC-JP","EUC-JP","ejis208"},
   { "EUC-KR","EUC-KR","ksc5601"},
   { "Extended_UNIX_Code_Packed_Format_for_Japanese","EUC-JP","ejis208"},
   { "GB2312","GB2312","gb2312" },
   { "GBK","GBK","GBK" },
   { "greek","ISO-8859-7","8859-7" },
   { "greek8","ISO-8859-7","8859-7" },
   { "ISO-8859-1","ISO-8859-1","8859-1" },
   { "ISO-8859-2","ISO-8859-2","8859-2" },
   { "ISO-8859-3","ISO-8859-3","8859-3" },
   { "ISO-8859-4","ISO-8859-4","8859-4" },
   { "ISO-8859-5","ISO-8859-5","8859-5" },
   { "ISO-8859-6","ISO-8859-6","8859-6" },
   { "ISO-8859-7","ISO-8859-7","8859-7" },
   { "ISO_8859-1","ISO-8859-1","8859-1" },
   { "ISO_8859-1:1987","ISO-8859-1","8859-1" },
   { "ISO_8859-2","ISO-8859-2","8859-2" },
   { "ISO_8859-2:1987","ISO-8859-2","8859-2" },
   { "ISO_8859-3","ISO-8859-3","8859-3" },
   { "ISO_8859-3:1988","ISO-8859-3","8859-3" },
   { "ISO_8859-4","ISO-8859-4","8859-4" },
   { "ISO_8859-4:1988","ISO-8859-4","8859-4" },
   { "ISO_8859-5","ISO-8859-5","8859-5" },
   { "ISO_8859-5:1988","ISO-8859-5","8859-5" },
   { "ISO_8859-6","ISO-8859-6","8859-6" },
   { "ISO_8859-6:1987","ISO-8859-6","8859-6" },
   { "ISO_8859-7","ISO-8859-7","8859-7" },
   { "ISO_8859-7:1987","ISO-8859-7","8859-7" },
   { "KOI8-R","KOI8-R","koi8r" },
   { "KOI8-U","KOI8-U","koi8ru" },
   { "KOI8R","KOI8-R","koi8r" },
   { "KOI8RU","KOI8-R","koi8ru" },
   { "korean","EUC-KR","ksc5601" },
   { "KSC5636","CP949","ksc" },
   { "KS_C_5601-1987","EUC-KR","ksc5601" },
   { "KS_C_5601-1989","EUC-KR","ksc5601" },
   { "KSC5601","EUC-KR","ksc5601" },
   { "KSC_5601","EUC-KR","ksc5601" },
   { "latin1","ISO-8859-1","8859-1" },
   { "latin2","ISO-8859-2","8859-2" },
   { "latin3","ISO-8859-3","8859-3" },
   { "latin4","ISO-8859-4","8859-4" },
   { "latin5","ISO-8859-9","8859-5" },
   { "SHIFT_JIS","SHIFT_JIS","shiftjis" },
   { "SHIFT-JIS","SHIFT_JIS","shiftjis" },
   { "SHIFTJIS","SHIFT_JIS","shiftjis" },
   { "UCS","UCS-2","unicode" },
   { "UCS-2","UCS-2","unicode" },
   { "UCS-2BE","UCS-2BE","unicode" },
   { "UCS-2LE","UCS-2LE","unicode_LE" },
   { "unicode","UCS-2","unicode" },
   { "utf-8","UTF-8","utf-8" },
   { "utf8","UTF-8","utf-8" },
   { "win1250","WINDOWS-1250","win1250" },
   { "win1251","WINDOWS-1251","win1251" },
   { "win1252","WINDOWS-1252","win1252" },
   { "win1253","WINDOWS-1253","win1253" },
   { "win1254","WINDOWS-1254","win1254" },
   { "win1255","WINDOWS-1255","win1255" },
   { "win1256","WINDOWS-1256","win1256" },
   { "win1257","WINDOWS-1257","win1257" },
   { "win1258","WINDOWS-1258","win1258" },
   { "windows-1250","WINDOWS-1250","win1250" },
   { "windows-1251","WINDOWS-1251","win1251" },
   { "windows-1252","WINDOWS-1252","win1252" },
   { "windows-1253","WINDOWS-1253","win1253" },
   { "windows-1254","WINDOWS-1254","win1254" },
   { "windows-1255","WINDOWS-1255","win1255" },
   { "windows-1256","WINDOWS-1256","win1256" },
   { "windows-1257","WINDOWS-1257","win1257" },
   { "windows-1258","WINDOWS-1258","win1258" },
   { "x-jis","SHIFT_JIS","shiftjis" },
   { "x-sjis","SHIFT_JIS","shiftjis" }
};

#define NBCHARSETIANA sizeof(refIANA)/sizeof(struct_iana)

static int compare_charset(const void *cs1,const void *cs2)
{
  return strcasecmp( ((const char **)cs1)[0], ((const char **)cs2)[0]);

}

const char *FindCNVCharset(const char *s) {
  struct_iana si;
  void *charset;
  si[0]=s;
  charset=bsearch(si,refIANA,NBCHARSETIANA,sizeof(struct_iana),compare_charset);
  if (charset) return ((const char**)charset)[2];
  else return NULL;
}

const char *FindISOCharset(const char *s) {
  struct_iana si;
  void *charset;
  si[0]=s;
  charset=bsearch(si,refIANA,NBCHARSETIANA,sizeof(struct_iana),compare_charset);
  if (charset) return ((const char**)charset)[1];
  else return NULL;
}

typedef const char* languages_encodings[2];

static languages_encodings const reflng_enc[]= {
  {"AR","ISO-8859-6"},
  {"AR","UTF-8"},
  {"AR","WINDOWS-1256"},
  {"DE","ISO-8859-1"},
  {"DE","ISO-8859-15"},
  {"DE","UTF-8"},
  {"DE","WINDOWS-1252"},
  {"EL","ISO-8859-7"},
  {"EL","UTF-8"},
  {"EL","WINDOWS-1253"},
  {"EN","BIG5"},
  {"EN","CP949"},
  {"EN","EUC-JP"},
  {"EN","EUC-KR"},
  {"EN","GB_2312"},
  {"EN","GB_2312-80"},
  {"EN","GBK"},
  {"EN","ISO-8859-1"},
  {"EN","ISO-8859-10"},
  {"EN","ISO-8859-11"},
  {"EN","ISO-8859-13"},
  {"EN","ISO-8859-14"},
  {"EN","ISO-8859-15"},
  {"EN","ISO-8859-2"},
  {"EN","ISO-8859-3"},
  {"EN","ISO-8859-4"},
  {"EN","ISO-8859-5"},
  {"EN","ISO-8859-6"},
  {"EN","ISO-8859-7"},
  {"EN","ISO-8859-8"},
  {"EN","ISO-8859-9"},
  {"EN","JIS_ENCODING"},
  {"EN","KOI8-R"},
  {"EN","KOI8-U"},
  {"EN","SHIFT_JIS"},
  {"EN","UTF-8"},
  {"EN","WINDOWS-1250"},
  {"EN","WINDOWS-1251"},
  {"EN","WINDOWS-1252"},
  {"EN","WINDOWS-1253"},
  {"EN","WINDOWS-1254"},
  {"EN","WINDOWS-1255"},
  {"EN","WINDOWS-1256"},
  {"EN","WINDOWS-1257"},
  {"EN","WINDOWS-1258"},
  {"ES","ISO-8859-1"},
  {"ES","ISO-8859-15"},
  {"ES","UTF-8"},
  {"ES","WINDOWS-1252"},
  {"FR","ISO-8859-1"},
  {"FR","ISO-8859-15"},
  {"FR","UTF-8"},
  {"FR","WINDOWS-1252"},
  {"IT","ISO-8859-1"},
  {"IT","ISO-8859-15"},
  {"IT","UTF-8"},
  {"IT","WINDOWS-1252"},
  {"JA","EUC-JP"},
  {"JA","JIS_ENCODING"},
  {"JA","SHIFT_JIS"},
  {"JA","UTF-8"},
  {"KO","CP949"},
  {"KO","EUC-KR"},
  {"KO","UTF-8"},
  {"NL","ISO-8859-1"},
  {"NL","ISO-8859-15"},
  {"NL","UTF-8"},
  {"NL","WINDOWS-1252"},
  {"PT","ISO-8859-1"},
  {"PT","ISO-8859-15"},
  {"PT","UTF-8"},
  {"PT","WINDOWS-1252"},
  {"RU","ISO-8859-5"},
  {"RU","KOI8-R"},
  {"RU","KOI8-U"},
  {"RU","UTF-8"},
  {"SV","ISO-8859-1"},
  {"SV","ISO-8859-15"},
  {"SV","UTF-8"},
  {"SV","WINDOWS-1252"},
  {"ZH","BIG5"},
  {"ZH","GB_2312"},
  {"ZH","GB_2312-80"},
  {"ZH","GBK"},
  {"ZH","UTF-8"}
};

#define NBLNGENC sizeof(reflng_enc)/sizeof(languages_encodings)

static int compare_lng_enc(const void *cs1,const void *cs2)
{
  int a=strcmp(((const char **)cs1)[0], ((const char **)cs2)[0]);
  if(a)
    return a;
  else
    return strcmp(((const char **)cs1)[1], ((const char **)cs2)[1]);
}
#ifdef XMLFLOW
int IsAdmissibleCharsetForLang(const char *charset,const char *iso_lng)
{
  languages_encodings l;
  l[0]=iso_lng;
  l[1]=SetUpperCase(charset);
  if(bsearch(l,reflng_enc,NBLNGENC,sizeof(languages_encodings),compare_lng_enc))
    return 1;
  else
    return 0;
}
#endif
