#include "Case.h"

using namespace std;

/*const char *SetCapitalized(const std::string &utf8)
{
  return SetCapitalized(utf8.c_str());
}*/

/*const char *SetCapitalized(const char *utf8) {
  int firstcharlen=utf8charlen(utf8);
  if (!firstcharlen) return utf8; // strange string, or incorrect utf8
  string U(utf8);
  string V(utf8);
  U.erase(firstcharlen);
  V.erase(0,firstcharlen);
  unirdata *u=findutfdescrpt(U.c_str());
  if (!u || uGeneralCategory(u)!=gc_Ll || !uUppercaseMapping(u)) { return utf8; }
  static string R;
  R=unicode2utf8(uUppercaseMapping(u))+V;
  return R.c_str();
  }*/

/*const char *SetUpperCase(const std::string &utf8)
{
  return SetUpperCase(utf8.c_str());
}*/

/*const char *SetUpperCase(const char *utf8) {
  int firstcharlen=utf8charlen(utf8);
  if (!firstcharlen) return utf8; // strange string, or incorrect utf8
  string U(utf8);
  string V(utf8);
  static string R;
  R="";

  while (U.length() && firstcharlen) {
    U.erase(firstcharlen);
    V.erase(0,firstcharlen);
    unirdata *u=findutfdescrpt(U.c_str());
    if (!u || uGeneralCategory(u)!=gc_Ll || !uUppercaseMapping(u)) {
      if(u && uCodePage(u)==0x00DF) // Special Case of the German  
	R+="SS";
      else
        R+=U;
    }
    else R+=unicode2utf8(uUppercaseMapping(u));
    U=V;
    firstcharlen=utf8charlen(U.c_str());
  }
  return R.c_str();
  }*/

const char *SetLowerCase(const std::string &utf8)
{
  return SetLowerCase(utf8.c_str());
}

/*int CaseSmallerThan(const char *s1,const char *s2) {
  while(s1 && s2) {
    int firstcharlen1=utf8charlen(s1);
    if (!firstcharlen1) return 0; // strange string, or incorrect utf8    
    int firstcharlen2=utf8charlen(s2);
    if (!firstcharlen2) return 0; // strange string, or incorrect utf8
    if (GetCase(s1)<GetCase(s2)) return 1;
    if (GetCase(s1)>GetCase(s2)) return 1;
    s1+=firstcharlen1;
    s2+=firstcharlen2;
  }
  if (s1 && !s2) return 1;
  return 0;
  }*/

const char *SetLowerCase(const char *utf8) {
  int firstcharlen=utf8charlen(utf8);
  if (!firstcharlen) return utf8; // strange string, or incorrect utf8
  string U(utf8);
  string V(utf8);
  static string R;
  R="";

  while (U.length() && firstcharlen) {
    U.erase(firstcharlen);
    V.erase(0,firstcharlen);
    unirdata *u=findutfdescrpt(U.c_str());
    if (!u || uGeneralCategory(u)!=gc_Lu || !uLowercaseMapping(u)) {
      R+=U;
    }
    else R+=unicode2utf8(uLowercaseMapping(u));
    U=V;
    firstcharlen=utf8charlen(U.c_str());
  }
  return R.c_str();
}

/*const char *SetCase(const std::string utf8,_case c, liste<int> caps)
{
  return SetCase(utf8.c_str(),c,caps);
}*/

/*const char *SetCase(const char *utf8,_case c, liste<int> caps) {
  if (c==_cmixed) {
    forutf8init();
    char s[5]; // buffer for one utf8 character
    static string S;
    S.erase();
    int pos=0;
    reader<int> Rcaps(caps);
    forutf8(s,utf8) {
      if (!Rcaps.fin() && pos==Rcaps.cellule()) {
	S+=SetCase(s,_cupper);
	Rcaps.next();
      } else {
	S+=s;
      }
      pos++;
    }
    return S.c_str();
  }
  return SetCase(utf8,c);
  }*/

/*const char *SetCase(const std::string &utf8, _case c)
{
  return SetCase(utf8.c_str(),c);
}*/
  
/*const char *SetCase(const char *utf8, _case c) {
  static string U;
  U=utf8;
  string tmp;
  switch (c) {
  case _cna:    break;
  case _cundef: break;
  case _clower:
    tmp=SetLowerCase(U.c_str());
    U=tmp;
    break;
  case _ccapit:
    tmp=SetCapitalized(U.c_str());
    U=tmp;
    break;
  case _callcap:
    break;
  case _cmixed: break; //should be done elsewhere
  case _cupper:
    tmp=SetUpperCase(U.c_str());
    U=tmp;
    break;
  }
  return U.c_str();
}*/

/*_case GetCase(const std::string &utf8)
{
  return GetCase(utf8.c_str());
}*/

_case GetCase(const char *utf8) {
  _case c=_cundef;
  forutf8init();
  char s[5]; // buffer for one utf8 character
  int first=1;
  bool lower_case_chars=false;
  bool preceding_char_is_separator=false;
  // Check case on first letter and ... following
  // "first letter" only count gc_Ll and gc_Lu

  unirdata *previous=NULL;

  forutf8(s,utf8) {
    unirdata *u=findutfdescrpt(s);

    if(!u)
      return _cundef;
    
    if (previous && uGeneralCategory(previous)==gc_Zs)
      preceding_char_is_separator=true;
    else
      preceding_char_is_separator=false;

    if (uFamily(u) == f_LATIN ||
	uFamily(u) == f_GREEK ||
	uFamily(u) == f_CYRILLIC) {

      if (!u || !isletter(uGeneralCategory(u))) {
	first=0;
	continue;
      }
      
      if (uGeneralCategory(u)==gc_Lu) {
	if (first) c=_ccapit;
	else {
	  if (c==_ccapit && !lower_case_chars) c=_cupper;
	  else if (c!=_cupper) c=_cmixed;
	}
	first=0;
      }
      else if (uGeneralCategory(u)==gc_Ll) {
	if (c==_cundef) c=_clower;
	else if (c!=_clower && c!=_ccapit && c!=_callcap) c=_cmixed;
	first=0;
	lower_case_chars=true;
      }
    }

    first=0;
    previous=u;
  }

  return c;
}

/*int isCapitalized(const std::string &utf8)
{
  return isCapitalized(utf8.c_str());
}*/
  
/*int isCapitalized(const char *utf8) {
  return GetCase(utf8)==_ccapit;
  }*/

/*int isUpperCase(const std::string &utf8)
{
  return isUpperCase(utf8.c_str());
}*/

/*int isUpperCase(const char *utf8) {
  return GetCase(utf8)==_cupper;
  }*/

/*int QuiteUpperCase_xmlflow(const std::string &utf8)
{
  return QuiteUpperCase_xmlflow(utf8.c_str());
}*/

/*int QuiteUpperCase_xmlflow(const char *utf8) {
  int count_cupper=0;
  int count_all=0;
  int count_clower=0;
  //print_debug("case",4,"Check QuiteUpperCase of %s=",utf8);
  forutf8init();
  char s[5]; // buffer for one utf8 character
  // Check case on first letter and ... following
  // "first letter" only count gc_Ll and gc_Lu
  forutf8(s,utf8) {
    count_all++;
    unirdata *u=findutfdescrpt(s);
    if (!u || !isletter(uGeneralCategory(u))) 
      {
	continue;
      }
    if (uGeneralCategory(u)==gc_Lu) {
      count_cupper++;
    }
    else if (uGeneralCategory(u)==gc_Ll) {
      count_clower++;
    }
  }

  // is Quite uppercase if :
    // count_upper>=2 && 
      //          count_clower/count_all<=1/3 && 
        //        count_cupper/count_all>=2/3         
  if (count_cupper>=2 && count_clower/(float)count_all<=0.35 && 
      count_cupper/(float)count_all>=0.65)
    {
      //print_debug("case",4,"   yes\n");
      return 1;
    }
  //print_debug("case",4,"   no\n");
  return 0;
  }*/

/*UBYTE oldlingCapitalization(const std::string &s)
{
  return oldlingCapitalization(s.c_str());
}*/

/*UBYTE oldlingCapitalization(char *s)
// Return oldling capitalization flags and change s accordingly
{
  std::string result;
  UBYTE flag=0;
  
  if (isUpperCase(s) || (isCapitalized(s) && utf8len(s)==1)) {
    flag=0x30; // ALL_CAPS
    result=SetLowerCase(s);
  } else {
    int firstcharlen=utf8charlen(s);
    result=s;
    string c=result.substr(0,firstcharlen);
    if(isCapitalized(c.c_str())) {
      flag=0x10;
      result.replace(0,firstcharlen,SetLowerCase(c.c_str()));
    }
  }

  if (result.length()>strlen(s)) // Weird but we do not want to change
    ;                            // the allocation, so let's not change s
  else
    strcpy(s,result.c_str());
    
  return flag;
}*/

/*const char *RestoreCase(const std::string &src, const std::string &tgt)
{
  return RestoreCase(src.c_str(),tgt.c_str());
}*/

/*const char *RestoreCase(const char *src, const char *tgt)
// Restore src case in target
{
  static std::string result;
  
  switch(GetCase(src)) {
    case _clower:
    // We do not change the case
      result=tgt;
      break;

    case _cupper:
    // tgt must be in uppercase
      result=SetUpperCase(tgt);
      break;
      
    case _ccapit:
    // tgt must be capitalized 
      result=SetCapitalized(tgt);
      break;

    default:
    // we cannot do much. let's at least capitalize the string if it
    // was initially capitalized
      std::string first_char=std::string(src,utf8charlen(src));
      if(isCapitalized(first_char))
        result=SetCapitalized(tgt);
      else
	result=tgt;
  }
  
  return result.c_str();
}*/

/*const char *FullRestoreCase(void *tok, const char *tgt)
{
  static std::string result;
  
  if(!tok)
    result=tgt;
  else
    result=FullRestoreCase(reinterpret_cast<token*>(tok)->norm,tgt);

  return result.c_str();
}*/

/*std::string FullRestoreCase(const std::string &src, const std::string &tgt)
  // Restore src case in target
{
  std::string result=RestoreCase(src,tgt);
  
  size_t len1=utf8len(src.c_str());
  size_t len2=utf8len(tgt.c_str());

  size_t len;
  
  if(len1<len2)
    len=len1;
  else
    len=len2;

  size_t k1=0,k2=0;
  
  for(size_t i=0;i<len;++i) {
    size_t first_char_length1=utf8charlen(src.c_str()+k1);
    size_t first_char_length2=utf8charlen(result.c_str()+k2);
  
    if(isCapitalized(std::string(src.c_str()+k1,first_char_length1))) {
      std::string uppercase_char=SetUpperCase(
	  std::string(result.c_str()+k2,first_char_length2));
      result.replace(k2,first_char_length2,uppercase_char);
      k2+=uppercase_char.size();
    } else
      k2+=first_char_length2;
    
    k1+=first_char_length1;
  }

  return result.c_str();
}*/

_case MergeCase(_case c1, _case c2)
{
  if(c1==_cna && c2==_cna)
    return _cna;
  
  if(c1==_cundef || c2==_cundef || c1==_cna || c2==_cna)
    return _cundef;
 
  switch (c1) {
    case _cupper:
      if (c2==_cupper)
	return _cupper;
      else
	return _cmixed;

    case _clower:
      if (c2==_clower)
	return _clower;
      else
	return _cmixed;

    case _ccapit:
      if (c2==_clower)
	return _ccapit;
      else
	return _cmixed;

    default:
      return _cmixed;
  }
}

_case CombineCaseWithUpper(_case c,int position) {
  switch(c) {
  case _cna:
  case _cundef:
  case _clower:
    if (position) return _cmixed;
    return _ccapit;
    break;
  case _ccapit:
    if (position==1) return _cupper;
    return _cmixed;
  default:
    return c;
  }
}
