#include <iostream>
#include <fstream>

#include <libxml/tree.h>
#include <libxml/parser.h>

#include "LinguisticDefinition/LingDef.h"
#include "LinguisticDefinition/XmlLingDefFormatter.h"
#include "MorphologyDefinition/MorphoDef.h"
#include "MorphologyDefinition/XmlMorphoDefFormatter.h"

#include "MorphoDictionary.h"
#include "XmlMorphoDictionaryFormatter.h"
#include "EnglishFormGenerator.h"

using namespace std;
using namespace LinguisticDefinition;
using namespace MorphologyDefinition;

/**
 *
 */
int main(int argc, char *argv[]) {
  if (argc < 4) {
    cout << "Usage: <lng code> <lingdef xml> <morphodef xml> <dict(s)>" <<endl;
    return 1;
  }

  LingDef lingDef(argv[1]);
  {
    xmlDocPtr doc = xmlParseFile(argv[2]);
    if (doc != NULL) {
      XmlLingDefFormatter formatter;
      formatter.populateLingDef(doc, lingDef);
      
      xmlFreeDoc(doc);
    }
  }

  MorphoDef morphoDef(argv[1]);
  morphoDef.
    registerFormGeneratorFactory(new EnglishFormGeneratorFactory(), "en");
  
  xmlDocPtr doc = xmlParseFile(argv[3]);
  if (doc != NULL) {
    XmlMorphoDefFormatter formatter;
    formatter.populateMorphoDef(doc, morphoDef);
      
    xmlFreeDoc(doc);
  }

  {
    XmlMorphoDictionaryFormatter formatter(lingDef, morphoDef);
    MorphoDictionary dict(lingDef, morphoDef);

    {for (int argIndex = 4; argIndex < argc; argIndex++) {
      xmlDocPtr doc = xmlParseFile(argv[argIndex]);
      if (doc != NULL) {
	formatter.populateMorphoDictionary(doc, dict);
	xmlFreeDoc(doc);
      }
    }}

    dict.inflect();

    cout << formatter.output(dict) << endl;
  }
    
  return 0;
}
