#ifndef _XMLMORPHODICTIONARYFORMATTER_H_
#define _XMLMORPHODICTIONARYFORMATTER_H_

#include <string>
#include <iostream>
#include <sstream>

#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <libxml/parser.h>
#include <libxml/xmlwriter.h>
#include <libxml/xmlreader.h>

#include "MorphoDictionaryFormatter.h"
#include "XmlMorphoDictionaryEntryFormatter.h"

/**
 *
 */
class XmlMorphoDictionaryFormatter : public MorphoDictionaryFormatter {
public:

  /**
   *
   */
  XmlMorphoDictionaryFormatter(const LinguisticDefinition::LingDef &,
			       const MorphologyDefinition::MorphoDef &);

  /**
   *
   */
  MorphoDictionary createMorphoDictionary(const std::string &xmlData);

  /**
   *
   */
  MorphoDictionary createMorphoDictionary(xmlDocPtr);

  /**
   *
   */
  MorphoDictionary createMorphoDictionary(xmlNodePtr);

  /**
   *
   */
  void populateMorphoDictionary(const std::string &xmlData,
				MorphoDictionary &);

  /**
   *
   */
  void populateMorphoDictionary(xmlDocPtr, MorphoDictionary &);

  /**
   *
   */
  void populateMorphoDictionary(xmlNodePtr, MorphoDictionary &);

  /**
   *
   */
  std::string output(const MorphoDictionary &) const;

  /**
   *
   */
  void output(const MorphoDictionary &, std::ostream &) const;

  /**
   *
   */
  void output(const MorphoDictionary &, xmlTextWriterPtr) const;

private:
  XmlMorphoDictionaryEntryFormatter d_entryFormatter;
};

#endif //_XMLMORPHODICTIONARYFORMATTER_H_
