#include "XmlMorphoDictionaryFormatter.h"

using namespace std;
using namespace LinguisticDefinition;
using namespace MorphologyDefinition;

/**
 *
 */
XmlMorphoDictionaryFormatter::
XmlMorphoDictionaryFormatter(const LingDef &lingDef,
			     const MorphoDef &morphoDef) :
  MorphoDictionaryFormatter(lingDef, morphoDef),
  d_entryFormatter(lingDef) {
}

/**
 *
 */
MorphoDictionary
XmlMorphoDictionaryFormatter::
createMorphoDictionary(const std::string &xmlData) {
  MorphoDictionary dict(getLingDef(), getMorphoDef());
  populateMorphoDictionary(xmlData, dict);
  return dict;
}

/**
 *
 */
MorphoDictionary
XmlMorphoDictionaryFormatter::createMorphoDictionary(xmlDocPtr doc) {
  MorphoDictionary dict(getLingDef(), getMorphoDef());
  populateMorphoDictionary(doc, dict);
  return dict;
}

/**
 *
 */
MorphoDictionary
XmlMorphoDictionaryFormatter::createMorphoDictionary(xmlNodePtr dictNode) {
  MorphoDictionary dict(getLingDef(), getMorphoDef());
  populateMorphoDictionary(dictNode, dict);
  return dict;
}

/**
 *
 */
void
XmlMorphoDictionaryFormatter::
populateMorphoDictionary(const std::string &xmlData,
			 MorphoDictionary &dict) {
  xmlDocPtr doc = xmlParseDoc((xmlChar *) xmlData.c_str());
  if (doc != NULL) {
    populateMorphoDictionary(doc, dict);
    xmlFreeDoc(doc);
  }
}

/**
 *
 */
void
XmlMorphoDictionaryFormatter::
populateMorphoDictionary(xmlDocPtr doc,
			 MorphoDictionary &dict) {
  xmlXPathContextPtr xpContext = xmlXPathNewContext(doc);
  xmlXPathObjectPtr xpObj =
    xmlXPathEvalExpression((xmlChar *) "//MorphoDict", xpContext);
  if (xpObj != NULL) {
    xmlNodeSetPtr nodeSet = xpObj->nodesetval;
    if (nodeSet != NULL && nodeSet->nodeNr > 0) {
      populateMorphoDictionary(nodeSet->nodeTab[0], dict);
    }
    xmlXPathFreeObject(xpObj);
  }
    
  xmlXPathFreeContext(xpContext);
}

/**
 *
 */
void
XmlMorphoDictionaryFormatter::
populateMorphoDictionary(xmlNodePtr dictNode,
			 MorphoDictionary &dict) {
  xmlXPathContextPtr xpContext = xmlXPathNewContext(dictNode->doc);
  xpContext->node = dictNode;

  xmlXPathObjectPtr xpObj =
    xmlXPathEvalExpression((xmlChar *) "//Entry", xpContext);
  if (xpObj != NULL) {
    xmlNodeSetPtr nodeSet = xpObj->nodesetval;
    if (nodeSet != NULL) {
      {for (int i = 0; i < nodeSet->nodeNr; i++) {
	d_entryFormatter.populateMorphoDictionaryEntry(nodeSet->nodeTab[i],
						       dict.createEntry());
      }}
    }
    xmlXPathFreeObject(xpObj);
  }
    
  xmlXPathFreeContext(xpContext);
}

/**
 *
 */
string
XmlMorphoDictionaryFormatter::
output(const MorphoDictionary &dict) const {
  stringstream s;
  output(dict, s);
  return s.str();
}

/**
 *
 */
void
XmlMorphoDictionaryFormatter::output(const MorphoDictionary &dict,
				     ostream &out) const {
  xmlOutputBufferPtr b = xmlAllocOutputBuffer(NULL);
  xmlTextWriterPtr writer = xmlNewTextWriter(b);
  xmlTextWriterSetIndent(writer, 1);
  output(dict, writer);
  out << xmlBufferContent(b->buffer);
  xmlFreeTextWriter(writer);
}

/**
 *
 */
void
XmlMorphoDictionaryFormatter::output(const MorphoDictionary &dict,
				     xmlTextWriterPtr writer) const {

  xmlTextWriterStartElement(writer, (xmlChar *) "MorphoDict");

  {for (MorphoDictionary::EntryIterator it = dict.entriesBegin();
	it != dict.entriesEnd(); ++it) {
    d_entryFormatter.output(**it, writer);
  }}

  xmlTextWriterEndElement(writer); //MorphoDict
}
