#ifndef _XMLMORPHODICTIONARYENTRYFORMATTER_H_
#define _XMLMORPHODICTIONARYENTRYFORMATTER_H_

#include <string>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <libxml/xmlwriter.h>

#include "MorphoDictionaryEntryFormatter.h"

#include "LinguisticDefinition/XmlLingFeaturesFormatter.h"

/**
 *
 */
class XmlMorphoDictionaryEntryFormatter :
  public MorphoDictionaryEntryFormatter {
public:

  /**
   *
   */
  XmlMorphoDictionaryEntryFormatter(const LinguisticDefinition::LingDef &);

  /**
   *
   */
  MorphoDictionaryEntry
  createMorphoDictionaryEntry(const std::string &xmlData);

  /**
   *
   */
  MorphoDictionaryEntry createMorphoDictionaryEntry(xmlNodePtr);

  /**
   *
   */
  bool populateMorphoDictionaryEntry(const std::string &xmlData,
				     MorphoDictionaryEntry &);

  /**
   *
   */
  bool populateMorphoDictionaryEntry(xmlDocPtr, MorphoDictionaryEntry &);

  /**
   *
   */
  bool populateMorphoDictionaryEntry(xmlNodePtr, MorphoDictionaryEntry &);

  /**
   *
   */
  std::string output(const MorphoDictionaryEntry &) const;

  /**
   *
   */
  void output(const MorphoDictionaryEntry &, std::ostream &) const;

  /**
   *
   */
  void output(const MorphoDictionaryEntry &, xmlTextWriterPtr) const;

private:
  LinguisticDefinition::XmlLingFeaturesFormatter d_featuresFormatter;
};

#endif //_XMLMORPHODICTIONARYENTRYFORMATTER_H_
