#ifndef _MORPHODICTIONARYENTRY_H_
#define _MORPHODICTIONARYENTRY_H_

#include <string>
#include <vector>

#include "LinguisticDefinition/LingDef.h"
#include "LinguisticDefinition/LingFeatures.h"
#include "MorphologyDefinition/Inflector.h"

/**
 *
 */
class MorphoDictionaryEntry {
public:

  /**
   *
   */
  MorphoDictionaryEntry(const LinguisticDefinition::LingDef &);

  /**
   *
   */
  MorphoDictionaryEntry(const LinguisticDefinition::LingDef &,
			const std::string &posName,
			const std::string &lemma);

  /**
   *
   */
  ~MorphoDictionaryEntry();

  /**
   *
   */
  MorphoDictionaryEntry(const MorphoDictionaryEntry &);

  /**
   *
   */
  void setPosName(const std::string &);

  /**
   *
   */
  void setLemma(const std::string &);

  /**
   *
   */
  const std::string &getPosName() const;

  /**
   *
   */
  const std::string &getLemma() const;

  /**
   *
   */
  void addFeature(const std::string &featureName,
		  bool isConstraint = false);

  /**
   *
   */
  typedef std::vector<std::string> FeatureList;
  typedef FeatureList::const_iterator FeatureIterator;

  /**
   *
   */
  FeatureIterator featuresBegin() const;

  /**
   *
   */
  FeatureIterator featuresEnd() const;

  /**
   *
   */
  FeatureIterator featureConstraintsBegin() const;

  /**
   *
   */
  FeatureIterator featureConstraintsEnd() const;

  /**
   *
   */
  void inflect(const MorphologyDefinition::Inflector &);

  /**
   *
   */
  void clearInflected();

  /**
   *
   */
  class Inflection {
  public:

    /**
     *
     */
    Inflection(MorphoDictionaryEntry &);

    /**
     *
     */
    Inflection(MorphoDictionaryEntry &,
	       const std::string &classId,
	       const std::string &declinationCode);

    /**
     *
     */
    Inflection(MorphoDictionaryEntry &,
	       const std::string &posName,
	       const std::string &classId,
	       const std::string &declinationCode);

    /**
     *
     */
    ~Inflection();

    /**
     *
     */
    Inflection(const Inflection &);

    /**
     *
     */
    void addFeature(const std::string &featureName,
		    bool isConstraint = false);

    /**
     *
     */
    void inflect(const MorphologyDefinition::Inflector &);

    /**
     *
     */
    const LinguisticDefinition::LingFeatures *getFeatures() const;

    /**
     *
     */
    const std::string &getClassId() const;

    /**
     *
     */
    const std::string &getDeclinationCode() const;

    /**
     *
     */
    const std::string &getPosName() const;

    /**
     *
     */
    const std::string &getStem() const;

    /**
     *
     */
    FeatureIterator featuresBegin() const;

    /**
     *
     */
    FeatureIterator featuresEnd() const;

    /**
     *
     */
    FeatureIterator featureConstraintsBegin() const;

    /**
     *
     */
    FeatureIterator featureConstraintsEnd() const;

    /**
     *
     */
    void setStem(const std::string &);

    /**
     *
     */
    bool isDerivation() const;

    /**
     *
     */
    typedef std::vector<const LinguisticDefinition::LingFeatures *>
    InflectedList;
    typedef InflectedList::const_iterator InflectedIterator;

    /**
     *
     */
    InflectedIterator inflectedBegin() const;

    /**
     *
     */
    InflectedIterator inflectedEnd() const;

    /**
     *
     */
    void clearInflected();

  private:

    /**
     *
     */
    void init(MorphoDictionaryEntry &,
	      const std::string &posName,
	      const std::string &classId,
	      const std::string &declinationCode);

    /**
     *
     */
    void inflectSub(const MorphologyDefinition::Inflector::Inflections &,
		    const LinguisticDefinition::LingFeatures &);

  private:
    MorphoDictionaryEntry &d_parent;

    bool d_isDerivation;
    std::string d_classId;
    std::string d_declinationCode;

    std::string d_posName;

    std::string d_stem;

    FeatureList d_features;
    FeatureList d_featureConstraints;

    LinguisticDefinition::LingFeatures *d_featuresObj;

    std::vector<const LinguisticDefinition::LingFeatures *> d_inflected;
  };

  /**
   *
   */
  Inflection &createInflection();

  /**
   *
   */
  Inflection &createInflection(const std::string &classId,
			       const std::string &declinationCode);

  /**
   *
   */
  Inflection &createDerivation(const std::string &posName,
			       const std::string &classId,
			       const std::string &declinationCode);

  /**
   *
   */
  const LinguisticDefinition::LingDef &getLingDef() const;

  /**
   *
   */
  typedef std::vector<Inflection *> InflectionList;
  typedef InflectionList::const_iterator InflectionIterator;

  /**
   *
   */
  InflectionIterator inflectionsBegin() const;

  /**
   *
   */
  InflectionIterator inflectionsEnd() const;

private:
  const LinguisticDefinition::LingDef &d_lingDef;

  std::string d_posName;
  std::string d_lemma;

  FeatureList d_features;
  FeatureList d_featureConstraints;

  InflectionList d_inflections;
};

#endif //_MORPHODICTIONARYENTRY_H_
