#ifndef _MORPHODICTIONARY_H_
#define _MORPHODICTIONARY_H_

#include <vector>

#include "LinguisticDefinition/LingDef.h"
#include "MorphologyDefinition/MorphoDef.h"
#include "MorphologyDefinition/Inflector.h"
#include "MorphoDictionaryEntry.h"

/**
 *
 */
class MorphoDictionary {
public:

  /**
   *
   */
  MorphoDictionary(const LinguisticDefinition::LingDef &,
		   const MorphologyDefinition::MorphoDef &);

  /**
   *
   */
  ~MorphoDictionary();

  /**
   *
   */
  MorphoDictionary(const MorphoDictionary &);

  /**
   *
   */
  MorphoDictionaryEntry &createEntry();

  /**
   *
   */
  void inflect();

  /**
   *
   */
  typedef std::vector<MorphoDictionaryEntry *> EntryList;
  typedef EntryList::const_iterator EntryIterator;

  /**
   *
   */
  EntryIterator entriesBegin() const;

  /**
   *
   */
  EntryIterator entriesEnd() const;

private:
  const LinguisticDefinition::LingDef &d_lingDef;
  const MorphologyDefinition::MorphoDef &d_morphoDef;
  EntryList d_entries;
};

#endif //_MORPHODICTIONARY_H_
