#include "MorphoDictionary.h"

using namespace std;
using namespace LinguisticDefinition;
using namespace MorphologyDefinition;

/**
 *
 */
MorphoDictionary::MorphoDictionary(const LingDef &lingDef,
				   const MorphoDef &morphoDef) :
  d_lingDef(lingDef),
  d_morphoDef(morphoDef) {
}

/**
 *
 */
MorphoDictionary::~MorphoDictionary() {
  {for (EntryIterator it = entriesBegin(); it != entriesEnd(); ++it) {
    delete *it;
  }}
}

/**
 *
 */
MorphoDictionary::MorphoDictionary(const MorphoDictionary &o) :
  d_lingDef(o.d_lingDef),
  d_morphoDef(o.d_morphoDef) {
  {for (EntryIterator it = entriesBegin(); it != entriesEnd(); ++it) {
    d_entries.push_back(new MorphoDictionaryEntry(**it));
  }}
}

/**
 *
 */
MorphoDictionaryEntry &MorphoDictionary::createEntry() {
  MorphoDictionaryEntry *entry = new MorphoDictionaryEntry(d_lingDef);
  d_entries.push_back(entry);
  return *entry;
}

/**
 *
 */
void MorphoDictionary::inflect() {
  Inflector inflector(d_morphoDef);
  {for (EntryList::iterator it = d_entries.begin();
	it != d_entries.end(); ++it) {
    (*it)->inflect(inflector);
  }}
}

/**
 *
 */
MorphoDictionary::EntryIterator MorphoDictionary::entriesBegin() const {
  return d_entries.begin();
}

/**
 *
 */
MorphoDictionary::EntryIterator MorphoDictionary::entriesEnd() const {
  return d_entries.end();
}
