#ifndef _ENGLISHFORMGENERATOR_H_
#define _ENGLISHFORMGENERATOR_H_

#include "MorphologyDefinition/FormGenerator.h"

/**
 *
 */
class EnglishFormGenerator :
  public MorphologyDefinition::DefaultFormGenerator {
public:

  /**
   *
   */
  EnglishFormGenerator(const std::string &suffix);

  /**
   *
   */
  EnglishFormGenerator(const EnglishFormGenerator &);

  /**
   *
   */
  AbstractFormGenerator *clone() const;

  /**
   *
   */
  std::string generateForm(const MorphologyDefinition::AbstractStem &) const;

private:
  bool d_doDoubling;
};

/**
 *
 */
class EnglishFormGeneratorFactory :
  public MorphologyDefinition::DefaultFormGeneratorFactory {
public:

  /**
   * Caller needs to claim ownership
   */
  MorphologyDefinition::AbstractFormGenerator *
  createFormGenerator(const std::string &value,
		      const MorphologyDefinition::Properties &,
		      const MorphologyDefinition::Properties &) const;

private:
};

#endif //_ENGLISHFORMGENERATOR_H_
