#include "EnglishFormGenerator.h"

using namespace std;
using namespace MorphologyDefinition;

/**
 *
 */
EnglishFormGenerator::EnglishFormGenerator(const std::string &suffix) :
  DefaultFormGenerator(suffix) {

  if (!suffix.empty() && suffix[0] == 'D') {
    d_doDoubling = true;
    setSuffix(suffix.substr(1));
  } else {
    d_doDoubling = false;
  }
}

/**
 *
 */
EnglishFormGenerator::EnglishFormGenerator(const EnglishFormGenerator &o) :
  DefaultFormGenerator(o),
  d_doDoubling(o.d_doDoubling) {
}

/**
 *
 */
AbstractFormGenerator *EnglishFormGenerator::clone() const {
  return new EnglishFormGenerator(*this);
}

/**
 *
 */
string EnglishFormGenerator::generateForm(const AbstractStem &stem) const {
  if (!d_doDoubling) {
    return ((const DefaultStem &) stem).getStem() + getSuffix();
  } else {
    string stemString = ((const DefaultStem &) stem).getStem();
    if (!stemString.empty()) {
      return stemString + stemString[stemString.length() - 1] + getSuffix();
    }
  }
  return "";
}

/**
 * Caller needs to claim ownership
 */
AbstractFormGenerator *
EnglishFormGeneratorFactory::createFormGenerator(const std::string &value,
						const Properties &,
						const Properties &) const {
  return new EnglishFormGenerator(value);
}
