#ifndef _MORPHOLOGYDEFINITION_XMLMORPHODEFFORMATTER_H_
#define _MORPHOLOGYDEFINITION_XMLMORPHODEFFORMATTER_H_

#include <string>

#include <libxml/tree.h>
#include <libxml/xpath.h>

#include "MorphologyDefinition/MorphoDef.h"
#include "MorphologyDefinition/MorphoDefFormatter.h"

namespace MorphologyDefinition {

  /**
   *
   */
  class XmlMorphoDefFormatter : public MorphoDefFormatter {
  public:

    /**
     *
     */
    XmlMorphoDefFormatter();

    /**
     * Creates a MorphoDef object for an XML document
     * @param xmlData The XML document, as a string
     * @param isoLanguageCode The ISO language code for the language to use
     */
    MorphoDef
    createMorphoDef(const std::string &xmlData,
                    const std::string &isoLanguageCode = "");

    /**
     * Creates a MorphoDef object for an XML document
     * @param doc The XML document, as a constructed xmlDoc
     * @param isoLanguageCode The ISO language code for the language to use
     */
    MorphoDef
    createMorphoDef(xmlDocPtr doc,
                    const std::string &isoLanguageCode = "");

    /**
     * A quick access function, to avoid copying the result object.
     * @param xmlData The XML document, as a string
     * @param morphoDef A pre-constructed MorphoDef object, which
     *                  will be populated
     * @return Whether or not the document was correct
     */
    void populateMorphoDef(const std::string &xmlData,
			   MorphoDef &morphoDef);

    /**
     * A quick access function, to avoid copying the result object.
     * @param doc The XML document, as a constructed xmlDoc
     * @param morphoDef A pre-constructed MorphoDef object, which
     *                  will be populated
     * @return Whether or not the document was correct
     */
    void populateMorphoDef(xmlDocPtr doc,
			   MorphoDef &morphoDef);
  
  private:

    /**
     *
     */
    bool langOk(const std::string &, const std::string &) const;

    /**
     *
     */
    bool langOk(xmlNodePtr, const MorphoDef &) const;

    /**
     *
     */
    void addMorphoDef(xmlNodePtr, MorphoDef &);

    /**
     *
     */
    void addClass(xmlNodePtr,
		  const std::string &defaultPluginId,
		  MorphoDef &);

    /**
     *
     */
    void addCase(xmlNodePtr,
		 MorphoDef::Class &,
		 MorphoDef &);

    /**
     *
     */
    void addDeclination(xmlNodePtr,
			MorphoDef::Class &,
 			const std::string &defaultPluginId,
			MorphoDef &);

    /**
     *
     */
    void addInflection(xmlNodePtr,
		       MorphoDef::Inflection &,
		       const std::string &defaultPluginId,
		       MorphoDef &);

    /**
     *
     */
    void addFeature(xmlNodePtr,
		    MorphoDef::Case &,
		    MorphoDef &);

    /**
     *
     */
    void addFeature(xmlNodePtr,
		    MorphoDef::Derivation &,
		    MorphoDef &);

    /**
     *
     */
    void addCascade(xmlNodePtr,
		    MorphoDef::Case &,
		    MorphoDef &);

    /**
     *
     */
    void addCascade(xmlNodePtr,
		    MorphoDef::Cascade &,
		    MorphoDef &);

  private:
  };

}

#endif //_MORPHOLOGYDEFINITION_XMLMORPHODEFFORMATTER_H_
