#include "MorphologyDefinition/MorphoDef.h"

#include <iostream> //TMP

using namespace std;
using namespace MorphologyDefinition;

/**
 *
 */
MorphoDef::MorphoDef(const string &isoCode) :
  d_isoLanguageCode(isoCode) {
  registerFormGeneratorFactory(new DefaultFormGeneratorFactory(), "");
}

/**
 *
 */
MorphoDef::~MorphoDef() {
  {for (MorphoDef::ClassIterator it = classesBegin();
        it != classesEnd(); ++it) {
    delete *it;
  }}

  {for (map<string, AbstractFormGeneratorFactory *>::const_iterator
	  it = d_formGeneratorFactories.begin();
	it != d_formGeneratorFactories.end(); ++it) {
    delete (*it).second;
  }}
}

/**
 *
 */
MorphoDef::MorphoDef(const MorphoDef &o) :
  d_isoLanguageCode(o.d_isoLanguageCode) {

  {for (MorphoDef::ClassIterator it = o.classesBegin();
        it != o.classesEnd(); ++it) {
    Class *newClass = new Class(**it);
    d_classes.push_back(newClass);
    d_classIdMap[newClass->getId()] = newClass;
  }}

  {for (map<string, AbstractFormGeneratorFactory *>::const_iterator
	  it = o.d_formGeneratorFactories.begin();
	it != o.d_formGeneratorFactories.end(); ++it) {
    registerFormGeneratorFactory((*it).second->clone(), (*it).first);
  }}
}

/**
 *
 */
const string &MorphoDef::getIsoLanguageCode() const {
  return d_isoLanguageCode;
}

/**
 *
 */
MorphoDef::Class &
MorphoDef::createClass(const string &id) {
  Class *newClass = new Class(*this, id);
  d_classes.push_back(newClass);
  d_classIdMap[id] = newClass;
  return *newClass;
}

/**
 *
 */
const MorphoDef::Class *
MorphoDef::getClass(const string &id) const {
  map<string, Class *>::const_iterator
    findIt = d_classIdMap.find(id);
  if (findIt != d_classIdMap.end()) {
    return (*findIt).second;
  }
  return NULL;
}

/**
 *
 */
MorphoDef::ClassIterator
MorphoDef::classesBegin() const {
  return d_classes.begin();
}

/**
 *
 */
MorphoDef::ClassIterator
MorphoDef::classesEnd() const {
  return d_classes.end();
}

/**
 *
 */
MorphoDef::Class::Class(MorphoDef &parent, const string &id) :
  d_parent(parent),
  d_id(id) {
}

/**
 *
 */
MorphoDef::Class::~Class() {
  {for (MorphoDef::Class::DeclinationIterator
          it = declinationsBegin();
        it != declinationsEnd(); ++it) {
    delete *it;
  }}
}

/**
 *
 */
MorphoDef::Class::Class(const Class &o) :
  d_parent(o.d_parent),
  d_id(o.d_id) {

  {for (MorphoDef::Class::DeclinationIterator
          it = o.declinationsBegin();
        it != o.declinationsEnd(); ++it) {
    addDeclination(new Declination(**it));
  }}

  {for (MorphoDef::Class::CaseIterator
          it = o.casesBegin();
        it != o.casesEnd(); ++it) {
    Case *newCase = new Case(*this, **it);
    addCase(newCase);
  }}
}

/**
 *
 */
void MorphoDef::Class::addDeclination(Declination *declination) {
  d_declinations.push_back(declination);

  vector<const Declination *> *v = NULL;

  map<string, vector<const Declination *> *>::iterator
    findIt = d_declinationNameMap.find(declination->getCode());
  if (findIt != d_declinationNameMap.end()) {
    v = (*findIt).second;
  } else {
    v = new vector<const Declination *>;
    d_declinationNameMap[declination->getCode()] = v;
  }

  v->push_back(declination);
}

/**
 *
 */
void MorphoDef::Class::addCase(Case *caseDef) {
  d_cases.push_back(caseDef);
  d_caseIdMap[caseDef->getId()] = caseDef;
}

/**
 *
 */
const string &MorphoDef::Class::getId() const {
  return d_id;
}

/**
 *
 */
MorphoDef::Declination &
MorphoDef::Class::createDeclination(const string &code) {
  Declination *newDeclination = new Declination(d_parent, code);
  addDeclination(newDeclination);
  return *newDeclination;
}

/**
 *
 */
const MorphoDef::Declination *
MorphoDef::Class::getDeclination(const string &code) const {
  map<string, vector<const Declination *> *>::const_iterator
    findIt = d_declinationNameMap.find(code);
  if (findIt != d_declinationNameMap.end()) {
    const vector<const Declination *> *v = (*findIt).second;
    if (v->empty()) {
      return NULL;
    }
    return *v->begin();
  }
  return NULL;
}

/**
 *
 */
const vector<const MorphoDef::Declination *> *
MorphoDef::Class::getDeclinations(const string &code) const {
  map<string, vector<const Declination *> *>::const_iterator
    findIt = d_declinationNameMap.find(code);
  if (findIt != d_declinationNameMap.end()) {
    return (*findIt).second;
  }
  return NULL;
}

/**
 *
 */
MorphoDef::Class::DeclinationIterator
MorphoDef::Class::declinationsBegin() const {
  return d_declinations.begin();
}

/**
 *
 */
MorphoDef::Class::DeclinationIterator
MorphoDef::Class::declinationsEnd() const {
  return d_declinations.end();
}

/**
 *
 */
MorphoDef::Case &
MorphoDef::Class::createCase(const string &id) {
  Case *newCase = new Case(*this, id);
  addCase(newCase);
  return *newCase;
}

/**
 *
 */
const MorphoDef::Case *
MorphoDef::Class::getCase(const string &id) const {
  map<string, Case *>::const_iterator
    findIt = d_caseIdMap.find(id);
  if (findIt != d_caseIdMap.end()) {
    return (*findIt).second;
  }
  return NULL;
}

/**
 *
 */
MorphoDef::Class::CaseIterator
MorphoDef::Class::casesBegin() const {
  return d_cases.begin();
}

/**
 *
 */
MorphoDef::Class::CaseIterator
MorphoDef::Class::casesEnd() const {
  return d_cases.end();
}

/**
 *
 */
MorphoDef::Case::Case(const Class &parent, const string &id) :
  d_parent(parent),
  d_id(id) {
}

/**
 *
 */
MorphoDef::Case::~Case() {
  {for (MorphoDef::Case::FeatureIterator
          it = featuresBegin();
        it != featuresEnd(); ++it) {
    delete *it;
  }}
  {for (MorphoDef::Case::CascadeIterator
          it = cascadesBegin();
        it != cascadesEnd(); ++it) {
    delete *it;
  }}
}

/**
 *
 */
MorphoDef::Case::Case(const Case &o) :
  d_parent(o.d_parent),
  d_id(o.d_id) {

  {for (MorphoDef::Case::FeatureIterator
          it = o.featuresBegin();
        it != o.featuresEnd(); ++it) {
    addFeature(new Feature(**it));
  }}

  {for (MorphoDef::Case::CascadeIterator
          it = o.cascadesBegin();
        it != o.cascadesEnd(); ++it) {
    d_cascades.push_back(new Cascade(**it));
  }}
}

/**
 *
 */
MorphoDef::Case::Case(const Class &parent, const Case &o) :
  d_parent(parent),
  d_id(o.d_id) {

  {for (MorphoDef::Case::FeatureIterator
          it = o.featuresBegin();
        it != o.featuresEnd(); ++it) {
    addFeature(new Feature(**it));
  }}

  {for (MorphoDef::Case::CascadeIterator
          it = o.cascadesBegin();
        it != o.cascadesEnd(); ++it) {
    d_cascades.push_back(new Cascade(**it));
  }}
}


/**
 *
 */
const MorphoDef::Class &MorphoDef::Case::getClass() const {
  return d_parent;
}

/**
 *
 */
const string &MorphoDef::Case::getId() const {
  return d_id;
}

/**
 *
 */
MorphoDef::Feature &
MorphoDef::Case::createFeature(const string &name) {
  Feature *newFeature = new Feature(name);
  addFeature(newFeature);
  return *newFeature;
}

/**
 *
 */
void MorphoDef::Case::addFeature(Feature *feature) {
  d_features.push_back(feature);
  d_featureNameMap[feature->getName()] = feature;
}

/**
 *
 */
bool MorphoDef::Case::hasFeature(const string &name) const {
  return d_featureNameMap.find(name) != d_featureNameMap.end();
}

/**
 *
 */
MorphoDef::Case::FeatureIterator
MorphoDef::Case::featuresBegin() const {
  return d_features.begin();
}

/**
 *
 */
MorphoDef::Case::FeatureIterator
MorphoDef::Case::featuresEnd() const {
  return d_features.end();
}

/**
 *
 */
int MorphoDef::Case::getNbrOfFeatures() const {
  return d_features.size();
}

/**
 *
 */
MorphoDef::Cascade &
MorphoDef::Case::
createCascade(const string &classId,
              const string &declinationCode) {
  Cascade *newCascade = new Cascade(classId, declinationCode);
  d_cascades.push_back(newCascade);
  return *newCascade;
}

/**
 *
 */
MorphoDef::Case::CascadeIterator
MorphoDef::Case::cascadesBegin() const {
  return d_cascades.begin();
}

/**
 *
 */
MorphoDef::Case::CascadeIterator
MorphoDef::Case::cascadesEnd() const {
  return d_cascades.end();
}

/**
 *
 */
MorphoDef::Declination::Declination(MorphoDef &parent, const string &code) :
  d_parent(parent),
  d_code(code),
  d_stemTrigger(NULL) {
}

/**
 *
 */
MorphoDef::Declination::~Declination() {
  {for (MorphoDef::Declination::InflectionIterator it = inflectionsBegin();
        it != inflectionsEnd(); ++it) {
    delete *it;
  }}

  //TODO what is this?
  {for (MorphoDef::Declination::DerivationIterator it = derivationsBegin();
        it != derivationsEnd(); ++it) {
    delete *it;
  }}
  delete d_stemTrigger;
}

/**
 *
 */
MorphoDef::Declination::Declination(const Declination &o) :
  d_parent(o.d_parent),
  d_code(o.d_code),
  d_stemTrigger(o.d_stemTrigger ? o.d_stemTrigger->clone() : NULL) {

  {for (MorphoDef::Declination::InflectionIterator it = o.inflectionsBegin();
        it != o.inflectionsEnd(); ++it) {
    d_inflections.push_back(new Inflection(**it));
  }}
}

/**
 *
 */
const string &MorphoDef::Declination::getCode() const {
  return d_code;
}

/**
 *
 */
const MorphoDef &MorphoDef::Declination::getMorphoDef() const {
  return d_parent;
}

/**
 *
 */
MorphoDef::Inflection &
MorphoDef::Declination::createInflection(const Case &c) {
  Inflection *newInflection = new Inflection(*this, &c);
  d_inflections.push_back(newInflection);
  return *newInflection;
}

/**
 *
 */
MorphoDef::Declination::InflectionIterator
MorphoDef::Declination::inflectionsBegin() const {
  return d_inflections.begin();
}

/**
 *
 */
MorphoDef::Declination::InflectionIterator
MorphoDef::Declination::inflectionsEnd() const {
  return d_inflections.end();
}

/**
 *
 */
MorphoDef::Derivation &
MorphoDef::Declination::
createDerivation(const string &posName,
                 const string &classId,
                 const string &declinationCode) {
  Derivation *newDerivation = new Derivation(*this,
					     posName,
					     classId,
					     declinationCode);
  d_derivations.push_back(newDerivation);
  return *newDerivation;
}

/**
 *
 */
MorphoDef::Declination::DerivationIterator
MorphoDef::Declination::derivationsBegin() const {
  return d_derivations.begin();
}

/**
 *
 */
MorphoDef::Declination::DerivationIterator
MorphoDef::Declination::derivationsEnd() const {
  return d_derivations.end();
}

/**
 *
 */
MorphoDef::Inflection::Inflection(const Declination &parent, const Case *c) :
  d_parent(parent),
  d_case(c),
  d_formGenerator(NULL) {
}

/**
 *
 */
MorphoDef::Inflection::~Inflection() {
  delete d_formGenerator;
}

/**
 *
 */
MorphoDef::Inflection::Inflection(const Inflection &o) :
  d_parent(o.d_parent),
  d_case(o.d_case),
  d_formGenerator(o.d_formGenerator ? o.d_formGenerator->clone() : NULL) {
}

/**
 *
 */
const MorphoDef::Declination &MorphoDef::Inflection::getDeclination() const {
  return d_parent;
}

/**
 *
 */
MorphoDef::Feature::Feature(const string &name) :
  d_name(name) {
}

/**
 *
 */
MorphoDef::Feature::~Feature() {
}

/**
 *
 */
const string &MorphoDef::Feature::getName() const {
  return d_name;
}

/**
 *
 */
MorphoDef::Cascade::
Cascade(const string &classId,
        const string &declinationCode) :
  d_classId(classId),
  d_declinationCode(declinationCode) {
}

/**
 *
 */
MorphoDef::Cascade::~Cascade() {
  {for (MorphoDef::Cascade::CascadeIterator
          it = cascadesBegin();
        it != cascadesEnd(); ++it) {
    delete *it;
  }}
}

/**
 *
 */
MorphoDef::Cascade::Cascade(const Cascade &o) :
  d_classId(o.d_classId),
  d_declinationCode(o.d_declinationCode) {
  {for (MorphoDef::Cascade::CascadeIterator
          it = o.cascadesBegin();
        it != o.cascadesEnd(); ++it) {
    d_cascades.push_back(new Cascade(**it));
  }}
}

/**
 *
 */
const string &
MorphoDef::Cascade::getClassId() const {
  return d_classId;
}

/**
 *
 */
const string &
MorphoDef::Cascade::getDeclinationCode() const {
  return d_declinationCode;
}

/**
 *
 */
MorphoDef::Cascade &
MorphoDef::Cascade::
createCascade(const string &classId,
              const string &declinationCode) {
  Cascade *newCascade = new Cascade(classId, declinationCode);
  d_cascades.push_back(newCascade);
  return *newCascade;
}

/**
 *
 */
MorphoDef::Cascade::CascadeIterator
MorphoDef::Cascade::cascadesBegin() const {
  return d_cascades.begin();
}

/**
 *
 */
MorphoDef::Cascade::CascadeIterator
MorphoDef::Cascade::cascadesEnd() const {
  return d_cascades.end();
}

/**
 *
 */
MorphoDef::Derivation::
Derivation(const Declination &parent,
	   const string &posName,
           const string &classId,
           const string &declinationCode) :
  Inflection(parent, NULL),
  d_posName(posName),
  d_classId(classId),
  d_declinationCode(declinationCode) {
}

/**
 *
 */
MorphoDef::Derivation::~Derivation() {
}

/**
 *
 */
MorphoDef::Derivation::Derivation(const Derivation &o) :
  Inflection(o),
  d_classId(o.d_classId),
  d_declinationCode(o.d_declinationCode) {
}

/**
 *
 */
const string &MorphoDef::Derivation::getPosName() const {
  return d_posName;
}

/**
 *
 */
const string &MorphoDef::Derivation::getClassId() const {
  return d_classId;
}

/**
 *
 */
const string &MorphoDef::Derivation::getDeclinationCode() const {
  return d_declinationCode;
}

/**
 *
 */
MorphoDef::Derivation::FeatureIterator
MorphoDef::Derivation::featuresBegin() const {
  return d_features.begin();
}

/**
 *
 */
MorphoDef::Derivation::FeatureIterator
MorphoDef::Derivation::featuresEnd() const {
  return d_features.end();
}

/**
 *
 */
void
MorphoDef::
registerFormGeneratorFactory(AbstractFormGeneratorFactory *factory,
			     const string &id) {
  map<string, AbstractFormGeneratorFactory *>::iterator
    findIt = d_formGeneratorFactories.find(id);
  if (findIt != d_formGeneratorFactories.end()) {
    delete (*findIt).second;
  }

  d_formGeneratorFactories[id] = factory;
}

/**
 *
 */
const AbstractFormGeneratorFactory *
MorphoDef::getFormGeneratorFactory(const string &id) const {
  map<string, AbstractFormGeneratorFactory *>::const_iterator
    findIt = d_formGeneratorFactories.find(id);
  if (findIt != d_formGeneratorFactories.end()) {
    return (*findIt).second;
  }
  return NULL;
}

/**
 *
 */
void MorphoDef::Declination::setStemTrigger(const string &pluginId,
					    const string &value) {
  const AbstractFormGeneratorFactory *factory =
    d_parent.getFormGeneratorFactory(pluginId);
  if (factory == NULL) {
    throw string("Could not find stem trigger factory ") + pluginId;
  } else {
    delete d_stemTrigger;
    Properties v1; //TODO
    Properties v2;
    d_stemTrigger = factory->createStemTrigger(value, v1, v2);
  }
}

/**
 *
 */
const AbstractStemTrigger *
MorphoDef::Declination::getStemTrigger() const {
  return d_stemTrigger;
}

/**
 *
 */
const MorphoDef::Case *MorphoDef::Inflection::getCase() const {
  return d_case;
}

/**
 *
 */
void MorphoDef::Inflection::setFormGenerator(const string &pluginId,
					     const string &value) {
  const AbstractFormGeneratorFactory *factory =
    d_parent.getMorphoDef().getFormGeneratorFactory(pluginId);
  if (factory == NULL) {
    throw string("Could not find form generator factory ") + pluginId;
  } else {
    delete d_formGenerator;
    Properties v1; //TODO
    Properties v2;
    d_formGenerator = factory->createFormGenerator(value, v1, v2);
  }
}

/**
 *
 */
const AbstractFormGenerator *
MorphoDef::Inflection::getFormGenerator() const {
  return d_formGenerator;
}
