#ifndef _MORPHOLOGYDEFINITION_INFLECTOR_H_
#define _MORPHOLOGYDEFINITION_INFLECTOR_H_

#include <string>
#include <vector>

#include "MorphologyDefinition/MorphoDef.h"

//TODO: variables (consonant/vowel definitions for example)

namespace MorphologyDefinition {

  /**
   *
   */
  class Inflector {
  public:

    /**
     *
     */
    Inflector(const MorphoDef &);

    /**
     *
     */
    ~Inflector();

    /**
     *
     */
    const MorphoDef &getMorphoDef() const;

    /**
     *
     */
    class Inflection {
    public:

      /**
       *
       */
      Inflection(const std::string &form);

      /**
       *
       */
      Inflection(const std::string &form,
		 const MorphoDef::Case &);

      /**
       *
       */
      virtual ~Inflection();

      /**
       *
       */
      Inflection(const Inflection &);

      /**
       *
       */
      const std::string &getForm() const;

      /**
       *
       */
      void addFeature(const MorphoDef::Feature *);

      /**
       *
       */
      void addFeatures(const MorphoDef::Case &);

      /**
       *
       */
      typedef std::vector<const MorphoDef::Feature *> FeatureList;
      typedef FeatureList::const_iterator FeatureIterator;

      /**
       *
       */
      FeatureIterator featuresBegin() const;

      /**
       *
       */
      FeatureIterator featuresEnd() const;

    private:
      std::string d_form;
      FeatureList d_features;
    };

    class Derivation;

    /**
     *
     */
    class Inflections {
    public:

      /**
       *
       */
      Inflections(const Inflector &,
		  const std::string &lemma,
		  const MorphoDef::Declination &);

      /**
       *
       */
      ~Inflections();

      /**
       *
       */
      Inflections(const Inflections &);

      /**
       *
       */
      const Inflector &getInflector() const;

      /**
       *
       */
      const std::string &getLemma() const;

      /**
       *
       */
      const MorphoDef::Declination &getDeclinationDef() const;

      /**
       *
       */
      Inflection &createInflection(const std::string &form);

      /**
       *
       */
      Inflection &createInflection(const std::string &form,
				   const MorphoDef::Inflection &);

      /**
       *
       */
      typedef std::vector<const Inflection *> InflectionList;
      typedef InflectionList::const_iterator InflectionIterator;

      /**
       *
       */
      InflectionIterator inflectionsBegin() const;

      /**
       *
       */
      InflectionIterator inflectionsEnd() const;

      /**
       *
       */
      Derivation &createDerivation(const std::string &lemma,
				   const MorphoDef::Derivation &);

      /**
       *
       */
      typedef std::vector<const Derivation *> DerivationList;
      typedef DerivationList::const_iterator DerivationIterator;

      /**
       *
       */
      DerivationIterator derivationsBegin() const;

      /**
       *
       */
      DerivationIterator derivationsEnd() const;

    private:
      const Inflector &d_inflector;
    
      std::string d_lemma;
      const MorphoDef::Declination &d_declinationDef;

      InflectionList d_inflections;
      DerivationList d_derivations;
    };

    /**
     *
     */
    class Derivation : public Inflection {
    public:

      /**
       *
       */
      Derivation(const Inflector &,
		 const std::string &posName,
		 const std::string &lemma,
		 const MorphoDef::Declination &);

      /**
       *
       */
      ~Derivation();

      /**
       *
       */
      Derivation(const Derivation &);

      /**
       *
       */
      const std::string &getPosName() const;

      /**
       *
       */
      Inflections &getModifiableInflections();

      /**
       *
       */
      const Inflections &getInflections() const;

    private:
      std::string d_posName;
      Inflections d_inflections;
    };

    /**
     *
     */
    Inflections inflect(const std::string &lemma,
			const MorphoDef::Declination &) const;

    /**
     *
     */
    Inflections inflect(const std::string &lemma,
			const std::string &classId,
			const std::string &declinationCode) const;

    /**
     *
     */
    bool inflect(Inflections &) const;

  private:

    /**
     *
     */
    void inflectCascade(const std::string &form,
			Inflections &,
			const MorphoDef::Cascade &,
			std::vector<const MorphoDef::Feature *>)
      const;

  private:
    const MorphoDef &d_morphoDef;
  };

}

#endif //_MORPHOLOGYDEFINITION_INFLECTOR_H_
