#ifndef _MORPHOLOGYDEFINITION_GUESSER_H_
#define _MORPHOLOGYDEFINITION_GUESSER_H_

#include <string>
#include <vector>
#include <set>

#include "MorphologyDefinition/MorphoDef.h"

namespace MorphologyDefinition {

  /**
   *
   */
  class Guesser {
  public:

    /**
     *
     */
    Guesser(const MorphoDef &);

    /**
     *
     */
    ~Guesser();

    /**
     *
     */
    const MorphoDef &getMorphoDef() const;

    /**
     *
     */
    std::string lemmatize(const std::string &form,
			  const MorphoDef::Inflection &) const;

    /**
     *
     */
    class Guess {
    public:

      /**
       *
       */
      Guess(const std::string &lemma,
	    const MorphoDef::Inflection &);

      /**
       *
       */
      const std::string &getLemma() const;

      /**
       *
       */
      const MorphoDef::Inflection &getInflection() const;

    private:
      std::string d_lemma;
      const MorphoDef::Inflection &d_inflection;
    };

    /**
     *
     */
    class Guesses {
    public:

      /**
       *
       */
      Guesses();

      /**
       *
       */
      ~Guesses();

      /**
       *
       */
      Guesses(const Guesses &);

      /**
       *
       */
      Guess &createGuess(const std::string &lemma,
			 const MorphoDef::Inflection &);

      /**
       *
       */
      typedef std::vector<const Guess *> GuessList;

      /**
       *
       */
      typedef GuessList::const_iterator GuessIterator;

      /**
       *
       */
      GuessIterator guessesBegin() const;

      /**
       *
       */
      GuessIterator guessesEnd() const;

    private:
      GuessList d_guesses;
    };

    /**
     *
     */
    void guess(const std::string &form, Guesses &result) const;

    /**
     *
     */
    void guess(const std::string &form,
	       const MorphoDef::Class &,
	       std::set<std::string> &features,
	       Guesses &result) const;

    /**
     *
     */
    void guess(const std::string &form,
	       const MorphoDef::Case &,
	       Guesses &result) const;

  private:

    /**
     *
     */
    void guess(const std::string &form,
	       const MorphoDef::Case *,
	       Guesses &result) const;
    
  private:
    const MorphoDef &d_morphoDef;
  };

}

#endif //_MORPHOLOGYDEFINITION_GUESSER_H_
