#include "MorphologyDefinition/Guesser.h"

using namespace std;
using namespace MorphologyDefinition;

/**
 *
 */
Guesser::Guesser(const MorphoDef &morphoDef) :
  d_morphoDef(morphoDef) {
}

/**
 *
 */
Guesser::~Guesser() {
}

/**
 *
 */
const MorphoDef &Guesser::getMorphoDef() const {
  return d_morphoDef;
}

/**
 *
 */
Guesser::Guess::Guess(const string &lemma,
		      const MorphoDef::Inflection &inflection) :
  d_lemma(lemma),
  d_inflection(inflection) {
}

/**
 *
 */
const string &Guesser::Guess::getLemma() const {
  return d_lemma;
}

/**
 *
 */
const MorphoDef::Inflection &Guesser::Guess::getInflection() const {
  return d_inflection;
}

/**
 *
 */
Guesser::Guesses::Guesses() {
}

/**
 *
 */
Guesser::Guesses::~Guesses() {
  {for (GuessIterator it = guessesBegin(); it != guessesEnd(); ++it) {
    delete *it;
  }}
}

/**
 *
 */
Guesser::Guesses::Guesses(const Guesses &o) {
  {for (GuessIterator it = o.guessesBegin(); it != o.guessesEnd(); ++it) {
    d_guesses.push_back(new Guess(**it));
  }}
}

/**
 *
 */
Guesser::Guess &
Guesser::Guesses::createGuess(const string &lemma,
			      const MorphoDef::Inflection &inflection) {
  Guess *newGuess = new Guess(lemma, inflection); 
  d_guesses.push_back(newGuess);
  return *newGuess;
}

/**
 *
 */
Guesser::Guesses::GuessIterator
Guesser::Guesses::guessesBegin() const {
  return d_guesses.begin();
}

/**
 *
 */
Guesser::Guesses::GuessIterator
Guesser::Guesses::guessesEnd() const {
  return d_guesses.end();
}

#include <iostream>

/**
 *
 */
string Guesser::lemmatize(const string &form,
			  const MorphoDef::Inflection &inflectionDef)
  const {

  const AbstractFormGenerator *formGenerator =
    inflectionDef.getFormGenerator();

  if (formGenerator == NULL) {
    throw "Could not retreive form generator";
  }

  const AbstractStemTrigger *stemTrigger =
    inflectionDef.getDeclination().getStemTrigger();

  if (stemTrigger == NULL) {
    throw "Could not retreive stem trigger";
  }

  AbstractStem *stem = formGenerator->generateStem(form);
  if (stem == NULL) {
    throw "Could not generate stem";
  }

  auto_ptr<AbstractStem> stemPtr(stem);
  return stemTrigger->lemmatize(*stem);
}

/**
 *
 */
void Guesser::guess(const string &form,
		    Guesses &result) const {
  guess(form, NULL, result);
}

/**
 *
 */
void Guesser::guess(const string &form,
		    const MorphoDef::Case &caseDef,
		    Guesses &result) const {
  guess(form, &caseDef, result);
}

/**
 *
 */
void Guesser::guess(const string &form,
		    const MorphoDef::Class &classDef,
		    set<string> &features,
		    Guesses &result) const {

  // Find the case definitions that have all the necessary features
  {for (MorphoDef::Class::CaseIterator it = classDef.casesBegin();
	it != classDef.casesEnd(); ++it) {
    const MorphoDef::Case *caseDef = *it;

    bool hasAllFeatures = true;
    {for (set<string>::iterator it2 = features.begin();
	  it2 != features.end(); ++it2) {
      if (!caseDef->hasFeature(*it2)) {
	hasAllFeatures = false;
	break;
      }
    }}

    if (hasAllFeatures) {
      {for (MorphoDef::Class::DeclinationIterator
	      it2 = classDef.declinationsBegin();
	    it2 != classDef.declinationsEnd(); ++it2) {
	const MorphoDef::Declination *declinationDef = *it2;
	
	{for (MorphoDef::Declination::InflectionIterator
		it3 = declinationDef->inflectionsBegin();
	      it3 != declinationDef->inflectionsEnd(); ++it3) {
	  const MorphoDef::Inflection *inflectionDef = *it3;

	  //TODO: have case index in morphodef?

	  if (caseDef == NULL || inflectionDef->getCase() == caseDef) {
	    try {
	      string lemma = lemmatize(form, *inflectionDef);
	      if (lemma != "") {
		result.createGuess(lemma, *inflectionDef);
	      }
	    } catch (const char *) {
	    } catch (string) {
	    }
	  }
	}}
      }}
    }
  }}
}

/**
 *
 */
void Guesser::guess(const string &form,
		    const MorphoDef::Case *caseDef,
		    Guesses &result) const {
  {for (MorphoDef::ClassIterator it = d_morphoDef.classesBegin();
	it != d_morphoDef.classesEnd(); ++it) {
    const MorphoDef::Class *classDef = *it;
    {for (MorphoDef::Class::DeclinationIterator
	    it2 = classDef->declinationsBegin();
	  it2 != classDef->declinationsEnd(); ++it2) {
      const MorphoDef::Declination *declinationDef = *it2;
      {for (MorphoDef::Declination::InflectionIterator
	      it3 = declinationDef->inflectionsBegin();
	    it3 != declinationDef->inflectionsEnd(); ++it3) {
	const MorphoDef::Inflection *inflectionDef = *it3;

	//TODO: have case index in morphodef?

	if (caseDef == NULL || inflectionDef->getCase() == caseDef) {
	  try {
	    string lemma = lemmatize(form, *inflectionDef);
	    if (lemma != "") {
	      result.createGuess(lemma, *inflectionDef);
	    }
	  } catch (const char *) {
	  } catch (string) {
	  }
	}
      }}
    }}
  }}
}
