#ifndef _MORPHOLOGYDEFINITION_FORMGENERATOR_H_
#define _MORPHOLOGYDEFINITION_FORMGENERATOR_H_

#include <string>
#include <vector>
#include <map>

//TODO: the name of this file is confusing

namespace MorphologyDefinition {

  /**
   *
   */
  class AbstractStem {
  public:

    /**
     *
     */
    AbstractStem();

    /**
     *
     */
    virtual ~AbstractStem();

  private:
  };

  /**
   *
   */
  class AbstractStemTrigger {
  public:

    /**
     *
     */
    AbstractStemTrigger();

    /**
     *
     */
    virtual ~AbstractStemTrigger();

    /**
     *
     */
    virtual AbstractStemTrigger *clone() const = 0;

    /**
     * Caller needs to claim ownership
     */
    virtual AbstractStem *trigger(const std::string &lemma) const = 0;

    /**
     *
     */
    virtual std::string lemmatize(const AbstractStem &) const = 0;

  private:
  };

  /**
   *
   */
  class AbstractFormGenerator {
  public:

    /**
     *
     */
    AbstractFormGenerator();

    /**
     *
     */
    virtual ~AbstractFormGenerator();

    /**
     *
     */
    virtual AbstractFormGenerator *clone() const = 0;

    /**
     *
     */
    virtual std::string generateForm(const AbstractStem &) const = 0;

    /**
     * Caller needs to claim ownership
     */
    virtual AbstractStem *generateStem(const std::string &) const = 0;

  private:
  };

  /**
   * Simple map wrapper
   */
  class Properties {
  public:

    /**
     *
     */
    Properties();

    /**
     *
     */
    ~Properties();

    /**
     *
     */
    void add(const std::string &key, const std::string &value);

    /**
     *
     */
    void getValue(const std::string &key, std::string &) const;

    /**
     *
     */
    void getValues(const std::string &key,
		   std::vector<std::string> &) const;

  private:
    std::multimap<std::string, std::string> d_map;
  };

  /**
   *
   */
  class AbstractFormGeneratorFactory {
  public:

    /**
     *
     */
    AbstractFormGeneratorFactory();

    /**
     *
     */
    virtual ~AbstractFormGeneratorFactory();

    /**
     *
     */
    virtual AbstractFormGeneratorFactory *clone() const = 0;


    /**
     * Caller needs to claim ownership
     */
    virtual AbstractFormGenerator *
    createFormGenerator(const std::string &value,
			const Properties &globalProperties,
			const Properties &parameters) const = 0;

    /**
     * Caller needs to claim ownership
     */
    virtual AbstractStemTrigger *
    createStemTrigger(const std::string &value,
		      const Properties &globalProperties,
		      const Properties &parameters) const = 0;

  private:
  };

  /**
   *
   */
  class DefaultStem : public AbstractStem {
  public:

    /**
     *
     */
    DefaultStem(const std::string &stem);

    /**
     *
     */
    ~DefaultStem();

    /**
     *
     */
    const std::string &getStem() const;

  private:
    std::string d_stem;
  };

  /**
   *
   */
  class DefaultStemTrigger :
    public AbstractStemTrigger {
  public:

    /**
     *
     */
    DefaultStemTrigger(const std::string &suffix);

    /**
     *
     */
    ~DefaultStemTrigger();

    /**
     *
     */
    DefaultStemTrigger(const DefaultStemTrigger &);

    /**
     *
     */
    AbstractStemTrigger *clone() const;

    /**
     *
     */
    AbstractStem *trigger(const std::string &lemma) const;

    /**
     *
     */
    std::string lemmatize(const AbstractStem &) const;

    /**
     *
     */
    const std::string &getSuffix() const;

    /**
     *
     */
    void setSuffix(const std::string &);

  private:
    std::string d_suffix;
  };

  /**
   *
   */
  class DefaultFormGenerator : public AbstractFormGenerator {
  public:
    
    /**
     *
     */
    DefaultFormGenerator(const std::string &suffix);

    /**
     *
     */
    ~DefaultFormGenerator();

    /**
     *
     */
    DefaultFormGenerator(const DefaultFormGenerator &);

    /**
     *
     */
    AbstractFormGenerator *clone() const;

    /**
     *
     */
    std::string generateForm(const AbstractStem &) const;

    /**
     *
     */
    AbstractStem *generateStem(const std::string &form) const;

    /**
     *
     */
    const std::string &getSuffix() const;

    /**
     *
     */
    void setSuffix(const std::string &);

  private:
    std::string d_suffix;
  };

  /**
   *
   */
  class DefaultFormGeneratorFactory :
    public AbstractFormGeneratorFactory {
  public:

    /**
     *
     */
    DefaultFormGeneratorFactory();

    /**
     *
     */
    ~DefaultFormGeneratorFactory();

    /**
     *
     */
    DefaultFormGeneratorFactory(const DefaultFormGeneratorFactory &);

    /**
     *
     */
    AbstractFormGeneratorFactory *clone() const;

    /**
     * Caller needs to claim ownership
     */
    AbstractFormGenerator *createFormGenerator(const std::string &value,
					       const Properties &,
					       const Properties &) const;
  
    /**
     * Caller needs to claim ownership
     */
    AbstractStemTrigger *createStemTrigger(const std::string &value,
					   const Properties &,
					   const Properties &) const;

  private:
  };

}

#endif //_MORPHOLOGYDEFINITION_FORMGENERATOR_H_
