#include "MorphologyDefinition/FormGenerator.h"

using namespace std;
using namespace MorphologyDefinition;

/**
 *
 */
Properties::Properties() {
}

/**
 *
 */
Properties::~Properties() {
}

/**
 *
 */
void Properties::add(const string &key, const string &value) {
}

/**
 *
 */
void Properties::getValue(const string &key, string &value) const {
}

/**
 *
 */
void Properties::getValues(const string &key,
			   vector<string> &v) const {
}

/**
 *
 */
AbstractStemTrigger::AbstractStemTrigger() {
}

/**
 *
 */
AbstractStemTrigger::~AbstractStemTrigger() {
}

/**
 *
 */
AbstractStem::AbstractStem() {
}

/**
 *
 */
AbstractStem::~AbstractStem() {
}

/**
 *
 */
AbstractFormGenerator::AbstractFormGenerator() {
}

/**
 *
 */
AbstractFormGenerator::~AbstractFormGenerator() {
}

/**
 *
 */
AbstractFormGeneratorFactory::AbstractFormGeneratorFactory() {
}

/**
 *
 */
AbstractFormGeneratorFactory::~AbstractFormGeneratorFactory() {
}

/**
 *
 */
DefaultFormGeneratorFactory::DefaultFormGeneratorFactory() {
}

/**
 *
 */
DefaultFormGeneratorFactory::~DefaultFormGeneratorFactory() {
}

/**
 *
 */
DefaultStemTrigger::DefaultStemTrigger(const string &suffix) :
  d_suffix(suffix) {
}

/**
 *
 */
DefaultStemTrigger::~DefaultStemTrigger() {
}

/**
 *
 */
DefaultStemTrigger::DefaultStemTrigger(const DefaultStemTrigger &o) :
  d_suffix(o.d_suffix) {
}

/**
 *
 */
AbstractStemTrigger *DefaultStemTrigger::clone() const {
  return new DefaultStemTrigger(*this);
}

/**
 *
 */
DefaultStem::DefaultStem(const string &stem) :
  AbstractStem(),
  d_stem(stem) {
}

/**
 *
 */
DefaultStem::~DefaultStem() {
}

/**
 *
 */
const string &DefaultStem::getStem() const {
  return d_stem;
}

/**
 *
 */
AbstractStem *DefaultStemTrigger::trigger(const string &lemma) const {
  if (d_suffix.length() <= lemma.length() &&
      lemma.substr(lemma.length() - d_suffix.length()) == d_suffix) {
    return
      new DefaultStem(lemma.substr(0, lemma.length() - d_suffix.length()));
  }
  return NULL;
}

/**
 *
 */
string DefaultStemTrigger::lemmatize(const AbstractStem &stem) const {
  return ((const DefaultStem &) stem).getStem() + d_suffix;
}

/**
 *
 */
DefaultFormGenerator::DefaultFormGenerator(const string &suffix) :
  d_suffix(suffix) {
}

/**
 *
 */
DefaultFormGenerator::~DefaultFormGenerator() {
}

/**
 *
 */
DefaultFormGenerator::DefaultFormGenerator(const DefaultFormGenerator &o) :
  d_suffix(o.d_suffix) {
}

/**
 *
 */
AbstractFormGenerator *DefaultFormGenerator::clone() const {
  return new DefaultFormGenerator(*this);
}

/**
 *
 */
const string &DefaultFormGenerator::getSuffix() const {
  return d_suffix;
}

/**
 *
 */
void DefaultFormGenerator::setSuffix(const string &val) {
  d_suffix = val;
}

/**
 *
 */
const string &DefaultStemTrigger::getSuffix() const {
  return d_suffix;
}

/**
 *
 */
void DefaultStemTrigger::setSuffix(const string &val) {
  d_suffix = val;
}

/**
 *
 */
string 
DefaultFormGenerator::generateForm(const AbstractStem &stem) const {
  return ((const DefaultStem &) stem).getStem() + d_suffix;
}

/**
 *
 */
AbstractStem *
DefaultFormGenerator::generateStem(const string &form) const {
  if (d_suffix.length() <= form.length() &&
      form.substr(form.length() - d_suffix.length()) == d_suffix) {
    return
      new DefaultStem(form.substr(0, form.length() - d_suffix.length()));
  }
  return NULL;
}

/**
 *
 */
DefaultFormGeneratorFactory::
DefaultFormGeneratorFactory(const DefaultFormGeneratorFactory &o) :
  AbstractFormGeneratorFactory(o) {
}

/**
 *
 */
AbstractFormGeneratorFactory *DefaultFormGeneratorFactory::clone() const {
  return new DefaultFormGeneratorFactory(*this);
}

/**
 *
 */
AbstractFormGenerator *
DefaultFormGeneratorFactory::
createFormGenerator(const string &value,
		    const Properties &globalProperties,
		    const Properties &parameters) const {
  return new DefaultFormGenerator(value);
}

/**
 *
 */
AbstractStemTrigger *
DefaultFormGeneratorFactory::
createStemTrigger(const string &value,
		  const Properties &globalProperties,
		  const Properties &parameters) const {
  return new DefaultStemTrigger(value);
}
