#include <iostream>
#include <fstream>

#include "LinguisticDefinition/XmlWordPatternFormatter.h"
#include "LinguisticDefinition/LingFeatures.h"

using namespace std;
using namespace LinguisticDefinition;

/**
 *
 */
int main(int argc, char *argv[]) {

  LingDef lingDef("ar");

  // Populate the definition
  {
    {
      LingDef::Pos &nounPos = lingDef.createPos("NOUN");
      {
	LingDef::Feature &genderFeature =
	  nounPos.createFeature("gender",
				LingDef::Feature::MISC,
				LingDef::Feature::ENUM);

	LingDef::Feature &masculineFeature =
	  genderFeature.createEnumValueFeature("masculine");
	masculineFeature.setDefault(true);

	LingDef::Feature &feminineFeature =
	  genderFeature.createEnumValueFeature("feminine");

	LingDef::Feature &caseFeature =
	  nounPos.createFeature("case",
				LingDef::Feature::MISC,
				LingDef::Feature::ENUM);

	LingDef::Feature &nominativeFeature =
	  caseFeature.createEnumValueFeature("nominative");
	nominativeFeature.setDefault(true);

	LingDef::Feature &genitiveFeature =
	  caseFeature.createEnumValueFeature("genitive");
      }
    }
  }

  // Create a word pattern
  {
    XmlWordPatternFormatter wordPatternFormater(lingDef);

    stringstream definitionSource;
    definitionSource << "<WordPattern>" << endl;
    definitionSource << " <And>" << endl;
    definitionSource << "  <Pos name='NOUN'/>" << endl;
    definitionSource << "  <Or>" << endl;
    definitionSource << "   <And>" << endl;
    definitionSource << "    <Feature name='feminine'/>" << endl;
    definitionSource << "    <Feature name='nominative'/>" << endl;
    definitionSource << "   </And>" << endl;
    definitionSource << "   <And>" << endl;
    definitionSource << "    <Feature name='masculine'/>" << endl;
    definitionSource << "    <Feature name='genitive'/>" << endl;
    definitionSource << "   </And>" << endl;
    definitionSource << "  </Or>" << endl;
    definitionSource << "  <Not>" << endl;
    definitionSource << "   <Lemma>toto</Lemma>" << endl;
    definitionSource << "  </Not>" << endl;
    definitionSource << " </And>" << endl;
    definitionSource << "</WordPattern>" << endl;
    xmlDocPtr doc = xmlParseDoc((xmlChar *) definitionSource.str().c_str());
    if (doc != NULL) {
      xmlXPathContextPtr xpContext = xmlXPathNewContext(doc);

      xmlXPathObjectPtr xpObj =
	xmlXPathEval((xmlChar *) "//WordPattern", xpContext);
      if (xpObj != NULL) {
	xmlNodeSetPtr nodeSet = xpObj->nodesetval;
	if (nodeSet != NULL) {
	  {for (int i = 0; i < nodeSet->nodeNr; i++) {
	    WordPattern wordPattern =
	      wordPatternFormater.createWordPattern(nodeSet->nodeTab[i]);

	    {
	      LingFeatures features(*lingDef.getPos("NOUN"));
	      features += "feminine";
	      features += "nominative";
	      cerr << wordPattern.matches(features) << endl;
	    }

	    {
	      LingFeatures features(*lingDef.getPos("NOUN"));
	      features += "masculine";
	      features += "genitive";
	      cerr << wordPattern.matches(features) << endl;
	    }

	    {
	      LingFeatures features(*lingDef.getPos("NOUN"));
	      features += "masculine";
	      cerr << wordPattern.matches(features) << endl;
	    }

	    {
	      LingFeatures features(*lingDef.getPos("NOUN"));
	      features += "feminine";
	      features += "nominative";
	      features.setLemma("toto");
	      cerr << wordPattern.matches(features) << endl;
	    }

	  }}
	}
	xmlXPathFreeObject(xpObj);
      }
      xmlXPathFreeContext(xpContext);
    }

    xmlFreeDoc(doc);
  }

  return 1;
}
