#include <iostream>
#include <fstream>

#include "LinguisticDefinition/LingDef.h"
#include "LinguisticDefinition/LingFeatures.h"
#include "LinguisticDefinition/XmlLingDefFormatter.h"
#include "LinguisticDefinition/XmlLingFeaturesFormatter.h"

using namespace std;
using namespace LinguisticDefinition;

/**
 *
 */
int main(int argc, char *argv[]) {

  // Create the definition
  stringstream definitionSource;
  definitionSource << "<LingDef>" << endl;
  definitionSource << " <Pos id='pos_noun' inherits='pos_base'>" << endl;
  definitionSource << "  <Name>NOUN</Name>" << endl;
  definitionSource << "  <Misc>" << endl;
  definitionSource << "   <Enum name='number'>" << endl;
  definitionSource << "    <Value name='singular'/>" << endl;
  definitionSource << "    <Value name='dual' xml:lang='ar'/>" << endl;
  definitionSource << "    <Value name='plural'/>" << endl;
  definitionSource << "   </Enum>" << endl;
  definitionSource << "  </Misc>" << endl;
  definitionSource << "  <Conflicts>" << endl;
  definitionSource << "   <Conflict aName='hello' bName='plural'/>" << endl;
  definitionSource << "  </Conflicts>" << endl;
  definitionSource << " </Pos>" << endl;
  definitionSource << " <Pos id='pos_base' xml:lang='!yy,!zz'>" << endl;
  definitionSource << "  <Misc>" << endl;
  definitionSource << "   <Boolean name='hello'/>" << endl;
  definitionSource << "  </Misc>" << endl;
  definitionSource << " </Pos>" << endl;
  definitionSource << "</LingDef>" << endl;
  XmlLingDefFormatter lingDefFormatter;
  LingDef lingDef =
    lingDefFormatter.createLingDef(definitionSource.str(), "xx");

  // Query the definition
  {
    const LingDef::Pos *nounPos = lingDef.getPos("NOUN");
    cerr << nounPos->getName() << endl;
    {
      const LingDef::Feature *helloFeature = nounPos->getFeature("hello");
      cerr << helloFeature->getName() << endl;
    }

    {
      const LingDef::Feature *numberFeature = nounPos->getFeature("number");
      cerr << numberFeature->getName() << endl;

      const LingDef::Feature *singularFeature =
	nounPos->getFeature("singular");
      cerr << singularFeature->getName() << endl;
      cerr << singularFeature->getParentEnum()->getName() << endl;

      const LingDef::Feature *dualFeature =
	nounPos->getFeature("dual");
      cerr << dualFeature << endl;

      const LingDef::Feature *pluralFeature =
	nounPos->getFeature("plural");
      cerr << pluralFeature->getName() << endl;
      cerr << pluralFeature->getParentEnum()->getName() << endl;

    }

    // Create a simple LingFeatures object
    {
      LingFeatures features(*nounPos);
      features += "singular";
      features += "bad";
      features += "hello";
      cerr << features.has("plural")
	   << features.has("singular")
	   << features.has("number")
	   << features.has("hello")
	   << features.has("bad")
	   << endl;

      // Make a copy, do the same test
      {
	LingFeatures featuresCopy(features);
	cerr << featuresCopy.has("plural")
	     << featuresCopy.has("singular")
	     << featuresCopy.has("number")
	     << featuresCopy.has("hello")
	     << featuresCopy.has("bad")
	     << endl;
      }

      // Perform assignment, do the same test
      {
	LingFeatures featuresCopy(*nounPos);
	featuresCopy = features;
	cerr << featuresCopy.has("plural")
	     << featuresCopy.has("singular")
	     << featuresCopy.has("number")
	     << featuresCopy.has("hello")
	     << featuresCopy.has("bad")
	     << endl;
      }

      cerr << "Should be 10100: ";
      features += "plural";
      cerr << features.has("plural")
	   << features.has("singular")
	   << features.has("number")
	   << features.has("hello")
	   << features.has("bad")
	   << endl;
    }

    // Create a LingFeatures object using the XmlLingFeaturesFormatter
    {
      stringstream definitionSource;
      definitionSource << "<LingFeatures pos=\"NOUN\">" << endl;
      definitionSource << " <Feature name=\"singular\"/>" << endl;
      definitionSource << " <Feature name=\"bad\"/>" << endl;
      definitionSource << " <Feature name=\"hello\"/>" << endl;
      definitionSource << "</LingFeatures>" << endl;
      XmlLingFeaturesFormatter formatter(lingDef);
      LingFeatures features =
	formatter.createLingFeatures(definitionSource.str());
      cerr << features.has("plural")
	   << features.has("singular")
	   << features.has("number")
	   << features.has("hello")
	   << features.has("bad")
	   << endl;

      formatter.output(features, cerr);
    }
  }

  return 1;
}
