#include <iostream>

#include "LinguisticDefinition/LingDef.h"
#include "LinguisticDefinition/SentencePattern.h"
#include "LinguisticDefinition/WordPattern.h"
#include "LinguisticDefinition/LingFeaturesSet.h"

using namespace std;
using namespace LinguisticDefinition;

/**
 *
 */
int main(int argc, char *argv[]) {

  LingDef lingDef("ar");

  // Populate the definition
  {
    {
      LingDef::Pos &basePos = lingDef.createVirtualPos();
      LingDef::Pos &nounPos = basePos.createSubPos("NOUN");
      {
	LingDef::Feature &helloFeature =
	  basePos.createFeature("hello",
				LingDef::Feature::MISC,
				LingDef::Feature::BOOLEAN);
      }
      
      {
	LingDef::Feature &numberFeature =
	  nounPos.createFeature("number",
				LingDef::Feature::MISC,
				LingDef::Feature::ENUM);

	LingDef::Feature &singularFeature =
	  numberFeature.createEnumValueFeature("singular");
	singularFeature.setDefault(true);
	
	LingDef::Feature &pluralFeature =
	  numberFeature.createEnumValueFeature("plural");
      }
    }
  }

  {
    WordPattern wordPattern;

    SentencePattern pattern;
    pattern.createElement();

    const LingDef::Pos *nounPos = lingDef.getPos("NOUN");
    const LingDef::Feature *helloFeature = nounPos->getFeature("hello");
    const LingDef::Feature *pluralFeature = nounPos->getFeature("plural");

    WordPattern::OrGroupElement &element =
      wordPattern.getModifiableRootElement();

    // [NOUN:((+hello+plural)|(-hello))]
    {
      {
	WordPattern::AndGroupElement &andElement = element.createAnd();
	andElement.createLeaf().setFeature(*helloFeature);
	andElement.createLeaf().setFeature(*pluralFeature);
      }

      {
	WordPattern::LeafElement &leafElement = element.createLeaf();
	leafElement.setFeature(*helloFeature);
	leafElement.setNegative();
      }
    }

    {
      LingFeatures features(*nounPos);
      cerr << wordPattern.matches(features) << endl;
    }

    {
      LingFeatures features(*nounPos);
      features += "hello";
      cerr << wordPattern.matches(features) << endl;
    }

    {
      LingFeatures features(*nounPos);
      features += "plural";
      cerr << wordPattern.matches(features) << endl;
    }

    {
      LingFeatures features(*nounPos);
      features += "hello";
      features += "plural";
      cerr << element.matches(features) << endl;
    }

    {
      LingFeaturesSet featuresSet;
      {
	LingFeatures features(*nounPos);
	features += "hello";
	featuresSet.add(features);
      }

      {
	LingFeatures features(*nounPos);
	features += "plural";
	featuresSet.add(features);
      }

      {
	LingFeatures features(*nounPos);
	features += "hello";
	features += "plural";
	featuresSet.add(features);
      }

      cerr << wordPattern.matches(featuresSet) << endl;
      cerr << "empty? " << wordPattern.reduce(featuresSet).isEmpty() << endl;
    }

    {
      LingFeaturesSet featuresSet;
      featuresSet.add(*nounPos);
      featuresSet.set("singular");
      featuresSet.set("plural");
      featuresSet.set("hello");

      cerr << wordPattern.matches(featuresSet) << endl;
      cerr << "empty? " << wordPattern.reduce(featuresSet).isEmpty() << endl;
    }

    // Copy pattern
    {
      SentencePattern patternCopy(pattern);
    }
  }

  return 1;
}
