#include <iostream>

#include "LinguisticDefinition/LingDef.h"
#include "LinguisticDefinition/LingFeaturesSet.h"

using namespace std;
using namespace LinguisticDefinition;

/**
 *
 */
int main(int argc, char *argv[]) {

  LingDef lingDef("ar");

  // Populate the definition
  {
    {
      LingDef::Pos &basePos = lingDef.createVirtualPos();
      LingDef::Pos &nounPos = basePos.createSubPos("NOUN");
      {
	LingDef::Feature &helloFeature =
	  basePos.createFeature("hello",
				LingDef::Feature::MISC,
				LingDef::Feature::BOOLEAN);
      }
      
      {
	LingDef::Feature &numberFeature =
	  nounPos.createFeature("number",
				LingDef::Feature::MISC,
				LingDef::Feature::ENUM);

	LingDef::Feature &singularFeature =
	  numberFeature.createEnumValueFeature("singular");
	singularFeature.setDefault(true);
	
	LingDef::Feature &pluralFeature =
	  numberFeature.createEnumValueFeature("plural");
      }

      {
	LingDef::Feature &genderFeature =
	  nounPos.createFeature("gender",
				LingDef::Feature::MISC,
				LingDef::Feature::ENUM);

	LingDef::Feature &singularFeature =
	  genderFeature.createEnumValueFeature("masculine");
	singularFeature.setDefault(true);
	
	LingDef::Feature &pluralFeature =
	  genderFeature.createEnumValueFeature("feminine");
      }

      LingDef::Pos &verbPos = basePos.createSubPos("VERB");
      {
	LingDef::Feature &numberFeature =
	  verbPos.createFeature("number",
				LingDef::Feature::MISC,
				LingDef::Feature::ENUM);

	LingDef::Feature &singularFeature =
	  numberFeature.createEnumValueFeature("singular");
	singularFeature.setDefault(true);
	
	LingDef::Feature &pluralFeature =
	  numberFeature.createEnumValueFeature("plural");
      }
    }
  }

  {
    const LingDef::Pos *nounPos = lingDef.getPos("NOUN");
    const LingDef::Pos *verbPos = lingDef.getPos("VERB");

    LingFeaturesSet featuresSet;
    {
      LingFeatures features(*nounPos);
      featuresSet.add(features);
    }

    {
      LingFeatures features(*nounPos);
      features += "hello";
      featuresSet.add(features);
    }

//     {
//       LingFeatures features(*verbPos);
//       features += "plural";
//       featuresSet.add(features);
//     }

    featuresSet.set("singular");
    featuresSet.set("plural");
    featuresSet.set("masculine");
    featuresSet.set("feminine");
    featuresSet.set("hello");
    {
      set<const LingDef::Feature *> enumValues;
      featuresSet.getEnumValues("number", enumValues);
      {for (set<const LingDef::Feature *>::iterator it = enumValues.begin();
	    it != enumValues.end(); ++it) {
	cerr << (*it)->getName() << endl;
      }}
    }

  }
}
