#include <iostream>
#include <fstream>

#include "LinguisticDefinition/LingDef.h"
#include "LinguisticDefinition/LingFeatures.h" //TODO? own test file?

using namespace std;
using namespace LinguisticDefinition;

/**
 *
 */
void testQuery(LingDef &lingDef) {
  const LingDef::Pos *nounPos = lingDef.getPos("NOUN");
  cerr << nounPos->getName() << endl;
  {
    const LingDef::Feature *helloFeature = nounPos->getFeature("hello");
    cerr << helloFeature->getName() << endl;
  }

  {
    const LingDef::Feature *numberFeature = nounPos->getFeature("number");
    cerr << numberFeature->getName() << endl;

    const LingDef::Feature *singularFeature =
      nounPos->getFeature("singular");
    cerr << singularFeature->getName() << endl;
    cerr << singularFeature->getParentEnum()->getName() << endl;

    const LingDef::Feature *pluralFeature =
      nounPos->getFeature("plural");
    cerr << pluralFeature->getName() << endl;
    cerr << pluralFeature->getParentEnum()->getName() << endl;
  }

  const LingDef::Pos *verbPos = lingDef.getPos("VERB");

  // Create a simple LingFeatures object
  {
    LingFeatures features(*nounPos);
    features += "singular";
    features += "bad";
    features += "hello";
    cerr << features.has("plural")
	 << features.has("singular")
	 << features.has("number")
	 << features.has("hello")
	 << features.has("bad")
	 << endl;

    // Make a copy, do the same test
    {
      LingFeatures featuresCopy(features);
      cerr << featuresCopy.has("plural")
	   << featuresCopy.has("singular")
	   << featuresCopy.has("number")
	   << featuresCopy.has("hello")
	   << featuresCopy.has("bad")
	   << endl;
    }

    // Perform assignment, do the same test
    {
      LingFeatures featuresCopy(*nounPos);
      featuresCopy = features;
      cerr << featuresCopy.has("plural")
	   << featuresCopy.has("singular")
	   << featuresCopy.has("number")
	   << featuresCopy.has("hello")
	   << featuresCopy.has("bad")
	   << endl;
    }
  }

  // Test the isDefined()
  {
    LingFeatures features(*nounPos);
    cerr << "should be 0: " << features.isDefined("plural") << endl;
    features += "plural";
    cerr << "should be 1: " << features.has("plural") << endl;
    cerr << "should be 1: " << features.isDefined("plural") << endl;
    features.unset("plural");
    cerr << "should be 0: " << features.has("plural") << endl;
    cerr << "should be 0: " << features.isDefined("plural") << endl;
    features -= "plural";
    cerr << "should be 0: " << features.has("plural") << endl;
    cerr << "should be 1: " << features.isDefined("plural") << endl;
    features.unset("plural");
    cerr << "should be 0: " << features.has("plural") << endl;
    cerr << "should be 0: " << features.isDefined("plural") << endl;
  }

  // Test virtual tree
  {
    {
      LingFeatures features(*nounPos);
      features += "woman";
      features += "something";

      cerr << "something? " << features.has("something") << endl;
      cerr << "woman? " << features.has("woman") << endl;
      cerr << "concrete? " << features.has("concrete") << endl;

      const LingDef::Feature *womanFeature = nounPos->getFeature("woman");
      cerr << "womanFeature=" << womanFeature << endl;
    }

    {
      LingFeatures features(*verbPos);
      features += "woman";
      cerr << "woman? " << features.has("woman") << endl;
      cerr << "concrete? " << features.has("concrete") << endl;
    }
  }

  // Test conflicts
  {
    LingFeatures features(*nounPos);
    cerr << "should be 0: " << features.has("one") << endl;
    cerr << "should be 0: " << features.has("two") << endl;
    features += "one";
    cerr << "should be 1: " << features.has("one") << endl;
    cerr << "should be 0: " << features.has("two") << endl;
    features += "two";
    cerr << "should be 0: " << features.has("one") << endl;
    cerr << "should be 1: " << features.has("two") << endl;
    features += "one";
    cerr << "should be 1: " << features.has("one") << endl;
    cerr << "should be 0: " << features.has("two") << endl;
  }
}

/**
 *
 */
int main(int argc, char *argv[]) {

  LingDef *lingDefCopy = NULL;

  // Test usage of the LingDef class
  {
    LingDef lingDef("ar");

    // Populate the definition
    {
      {
	LingDef::Pos &basePos = lingDef.createVirtualPos();
	LingDef::Pos &nounPos = basePos.createSubPos("NOUN");
	{
	  LingDef::Feature &helloFeature =
	    basePos.createFeature("hello",
				  LingDef::Feature::MISC,
				  LingDef::Feature::BOOLEAN);

	  LingDef::Feature &numberFeature =
	    nounPos.createFeature("number",
				  LingDef::Feature::MISC,
				  LingDef::Feature::ENUM);

	  LingDef::Feature &singularFeature =
	    numberFeature.createEnumValueFeature("singular");
	  singularFeature.setDefault(true);

	  LingDef::Feature &pluralFeature =
	    numberFeature.createEnumValueFeature("plural");


	  LingDef::Feature &oneFeature =
	    basePos.createFeature("one",
				  LingDef::Feature::MISC,
				  LingDef::Feature::BOOLEAN);

	  LingDef::Feature &twoFeature =
	    basePos.createFeature("two",
				  LingDef::Feature::MISC,
				  LingDef::Feature::BOOLEAN);

	  oneFeature.addConflict(twoFeature);
	}

	LingDef::Pos &verbPos = basePos.createSubPos("VERB");

	{
	  LingDef::Tree &semTree = lingDef.createTree("semtree");
	  semTree.getRootNode().
	    createChildNode("concrete").
	    createChildNode("human").
	    createChildNode("woman");
	  semTree.getRootNode().
	    createChildNode("abstract");

	  LingDef::Feature &semFeature =
	    nounPos.createFeature("sem",
				  LingDef::Feature::MISC,
				  LingDef::Feature::VTREE);
	  semFeature.setTree(semTree);
	}
      }

    }

    // Query the definition
    testQuery(lingDef);

    // Create a copy before the object lingDef goes out of scope, to make
    // sure that we copied the structure correctly
    lingDefCopy = new LingDef(lingDef);
  }

  cerr << "====================" << endl;

  {
    // Repeat the query test, now with the copied object
    testQuery(*lingDefCopy);
  }

  delete lingDefCopy;

  return 1;
}
