#include <iostream>
#include <fstream>

#include "LinguisticDefinition/LingDef.h"
#include "LinguisticDefinition/LingFeatures.h" //TODO? own test file?

using namespace std;
using namespace LinguisticDefinition;

/**
 *
 */
int main(int argc, char *argv[]) {

  LingDef *lingDefCopy = NULL;

  // Test usage of the LingDef class
  {
    LingDef lingDef("ar");

    // Populate the definition
    {
      {
	LingDef::Pos &basePos = lingDef.createVirtualPos();
	LingDef::Pos &nounPos = basePos.createSubPos("NOUN");
	{
	  LingDef::Feature &helloFeature =
	    basePos.createFeature("hello",
				  LingDef::Feature::MISC,
				  LingDef::Feature::BOOLEAN);
	}

	{
	  LingDef::Feature &numberFeature =
	    nounPos.createFeature("number",
				  LingDef::Feature::MISC,
				  LingDef::Feature::ENUM);

	  LingDef::Feature &singularFeature =
	    numberFeature.createEnumValueFeature("singular");
	  singularFeature.setDefault(true);

	  LingDef::Feature &pluralFeature =
	    numberFeature.createEnumValueFeature("plural");
	}
      }

      {
	LingDef::Tree &semTree = lingDef.createTree("semtree");
	semTree.getRootNode().
	  createChildNode("concrete").
	  createChildNode("human").
	  createChildNode("woman");
	semTree.getRootNode().
	  createChildNode("abstract");
      }
    }

    // Query the definition
    {
      const LingDef::Pos *nounPos = lingDef.getPos("NOUN");
      cerr << nounPos->getName() << endl;
      {
	const LingDef::Feature *helloFeature = nounPos->getFeature("hello");
	cerr << helloFeature->getName() << endl;
      }

      {
	const LingDef::Feature *numberFeature = nounPos->getFeature("number");
	cerr << numberFeature->getName() << endl;

	const LingDef::Feature *singularFeature =
	  nounPos->getFeature("singular");
	cerr << singularFeature->getName() << endl;
	cerr << singularFeature->getParentEnum()->getName() << endl;

	const LingDef::Feature *pluralFeature =
	  nounPos->getFeature("plural");
	cerr << pluralFeature->getName() << endl;
	cerr << pluralFeature->getParentEnum()->getName() << endl;
      }
    }


    // Create a copy before the object lingDef goes out of scope, to make
    // sure that we copied the structure correctly
    lingDefCopy = new LingDef(lingDef);
  }


  {
    // Repeat the query test, now with the copied object
    {
      const LingDef::Pos *nounPos = lingDefCopy->getPos("NOUN");
      cerr << nounPos->getName() << endl;
      {
	const LingDef::Feature *helloFeature = nounPos->getFeature("hello");
	cerr << helloFeature->getName() << endl;
      }

      {
	const LingDef::Feature *numberFeature = nounPos->getFeature("number");
	cerr << numberFeature->getName() << endl;

	const LingDef::Feature *singularFeature =
	  nounPos->getFeature("singular");
	cerr << singularFeature->getName() << endl;
	cerr << singularFeature->getParentEnum()->getName() << endl;

	const LingDef::Feature *pluralFeature =
	  nounPos->getFeature("plural");
	cerr << pluralFeature->getName() << endl;
	cerr << pluralFeature->getParentEnum()->getName() << endl;
      }
    }
  }

  delete lingDefCopy;

  return 0;
}
