#ifndef _LINGUISTICDEFINITION_XMLWORDPATTERNFORMATTER_H_
#define _LINGUISTICDEFINITION_XMLWORDPATTERNFORMATTER_H_

#include <string>
#include <iostream>

#include <libxml/tree.h>
#include <libxml/xpath.h>

#include "LinguisticDefinition/LingDef.h"
#include "LinguisticDefinition/WordPattern.h"
#include "LinguisticDefinition/WordPatternFormatter.h"

namespace LinguisticDefinition {

  /**
   *
   */
  class XmlWordPatternFormatter : public WordPatternFormatter {
  public:

    /**
     *
     */
    XmlWordPatternFormatter(const LingDef &);

    /**
     *
     */
    WordPattern createWordPattern(xmlNodePtr);

    /**
     *
     */
    bool populateWordPattern(xmlNodePtr, WordPattern &);

  private:

    /**
     *
     */
    bool go(xmlNodePtr, WordPattern::GroupElement &, const LingDef::Pos *&);

  };

}

#endif //_LINGUISTICDEFINITION_XMLWORDPATTERNFORMATTER_H_
