#include "LinguisticDefinition/XmlWordPatternFormatter.h"

#include <iostream>

using namespace std;
using namespace LinguisticDefinition;

/**
 *
 */
XmlWordPatternFormatter::XmlWordPatternFormatter(const LingDef &lingDef) :
  WordPatternFormatter(lingDef) {
}

/**
 *
 */
WordPattern XmlWordPatternFormatter::createWordPattern(xmlNodePtr node) {
  WordPattern expression;
  populateWordPattern(node, expression);
  return expression;
}

/**
 *
 */
bool XmlWordPatternFormatter::populateWordPattern(xmlNodePtr node,
						  WordPattern &wordPattern) {

  const LingDef::Pos *posDef = NULL;
  go(node, wordPattern.getModifiableRootElement(), posDef);

  return true;
}

/**
 *
 */
bool XmlWordPatternFormatter::go(xmlNodePtr node,
				 WordPattern::GroupElement &element,
				 const LingDef::Pos *&posDef) {
  xmlXPathContextPtr xpContext = xmlXPathNewContext(node->doc);
  xpContext->node = node;

  xmlXPathObjectPtr xpObj =
    xmlXPathEval((xmlChar *) "And|Or|Not|Pos|Feature|Form|Lemma",
		 xpContext);
  if (xpObj != NULL) {
    xmlNodeSetPtr nodeSet = xpObj->nodesetval;
    if (nodeSet != NULL) {
      {for (int i = 0; i < nodeSet->nodeNr; i++) {
	xmlNodePtr subNode = nodeSet->nodeTab[i];
	
	if (xmlStrcmp(subNode->name, (xmlChar *) "And") == 0) {
	  go(subNode, element.createAnd(), posDef);

	} else if (xmlStrcmp(subNode->name, (xmlChar *) "Or") == 0) {
	  go(subNode, element.createOr(), posDef);

	} else if (xmlStrcmp(subNode->name, (xmlChar *) "Not") == 0) {
	  WordPattern::GroupElement &notElement = element.createAnd();
	  notElement.setNegative();
	  go(subNode, notElement, posDef);

	} else if (xmlStrcmp(subNode->name, (xmlChar *) "Pos") == 0) {
	  xmlChar *tmp = xmlGetProp(subNode, (xmlChar *) "name");
	  if (tmp != NULL) {
	    const LingDef::Pos *pos = getLingDef().getPos((char *) tmp);
	    if (pos == NULL) {
	      cerr << "Feature '" << (char *) tmp << "' not defined" << endl;
	    } else {
	      posDef = pos;
	      element.createLeaf().setPosDef(*pos);
	    }
	    xmlFree(tmp);
	  }

	} else if (xmlStrcmp(subNode->name, (xmlChar *) "Feature") == 0) {
	  if (posDef == NULL) {
	    cerr << "Must have a pos before feature" << endl;
	  } else {
	    xmlChar *tmp = xmlGetProp(subNode, (xmlChar *) "name");
	    if (tmp != NULL) {
	      const LingDef::Feature *feature =
		posDef->getFeature((char *) tmp);
	      if (feature == NULL) {
		cerr << "Feature '" << (char *) tmp << "' not defined" << endl;
	      } else {
		element.createLeaf().setFeature(*feature);
	      }
	      xmlFree(tmp);
	    }
	  }

	} else if (xmlStrcmp(subNode->name, (xmlChar *) "Form") == 0) {
	  xmlChar *tmp = xmlNodeGetContent(subNode);
	  if (tmp != NULL) {
	    element.createLeaf().setForm((char *) tmp);
	    xmlFree(tmp);
	  }

	} else if (xmlStrcmp(subNode->name, (xmlChar *) "Lemma") == 0) {
	  xmlChar *tmp = xmlNodeGetContent(subNode);
	  if (tmp != NULL) {
	    element.createLeaf().setLemma((char *) tmp);
	    xmlFree(tmp);
	  }
	}

      }}
    }
    xmlXPathFreeObject(xpObj);
  }

  xmlXPathFreeContext(xpContext);

  return true;
}
