#ifndef _LINGUISTICDEFINITION_XMLLINGFEATURESFORMATTER_H_
#define _LINGUISTICDEFINITION_XMLLINGFEATURESFORMATTER_H_

#include <string>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <libxml/xmlwriter.h>

#include "LingDef.h"
#include "LingFeatures.h"
#include "LingFeaturesFormatter.h"

namespace LinguisticDefinition {

  /**
   *
   */
  class XmlLingFeaturesFormatter : public LingFeaturesFormatter {
  public:

    /**
     *
     */
    XmlLingFeaturesFormatter(const LingDef &);

    /**
     *
     */
    LingFeatures createLingFeatures(const std::string &xmlData);

    /**
     *
     */
    LingFeatures createLingFeatures(xmlNodePtr);

    /**
     *
     */
    bool populateLingFeatures(const std::string &xmlData, LingFeatures &);

    /**
     *
     */
    bool populateLingFeatures(xmlNodePtr, LingFeatures &);

    /**
     *
     */
    std::string output(const LingFeatures &) const;

    /**
     *
     */
    void output(const LingFeatures &, std::ostream &) const;

    /**
     *
     */
    void output(const LingFeatures &, xmlTextWriterPtr) const;

  private:
  };

}

#endif //_LINGUISTICDEFINITION_XMLLINGFEATURESFORMATTER_H_
