#include "LinguisticDefinition/WordPattern.h"

using namespace std;
using namespace LinguisticDefinition;

/**
 *
 */
WordPattern::WordPattern() :
  d_rootElement(*this) {
}

/**
 *
 */
WordPattern::~WordPattern() {
  {for (ReferenceIterator it = referencesBegin();
	it != referencesEnd(); ++it) {
    delete *it;
  }}
}

/**
 *
 */
WordPattern::WordPattern(const WordPattern &o) :
  d_rootElement(o.d_rootElement) {
  {for (ReferenceIterator it = o.referencesBegin();
	it != o.referencesEnd(); ++it) {
    d_references.push_back(new Reference(**it));
  }}
}

/**
 *
 */
WordPattern::OrGroupElement &WordPattern::getModifiableRootElement() {
  return d_rootElement;
}

/**
 *
 */
const WordPattern::OrGroupElement &WordPattern::getRootElement() const {
  return d_rootElement;
}

/**
 *
 */
bool WordPattern::matches(const LingFeatures &features) const {
  return d_rootElement.matches(features);
}

/**
 *
 */
bool WordPattern::matches(const LingFeaturesSet &features) const {
  {for (LingFeaturesSet::ElementIterator it = features.elementsBegin();
	it != features.elementsEnd(); ++it) {
    if (d_rootElement.matches(**it)) {
      return true;
    }
  }}

  return features.isEmpty();
}

/**
 *
 */
LingFeaturesSet WordPattern::reduce(const LingFeaturesSet &inSet) const {
  LingFeaturesSet outSet;

  {for (LingFeaturesSet::ElementIterator it = inSet.elementsBegin();
	it != inSet.elementsEnd(); ++it) {
    if (d_rootElement.matches(**it)) {
      outSet.add(**it);
    }
  }}

  return outSet;
}

/**
 *
 */
void WordPattern::generate(vector<const LingFeatures *> &v) const {
  d_rootElement.generate(v, NULL);
}

/**
 *
 */
WordPattern::Element::Element(const WordPattern &element) :
  d_element(element),
  d_negative(false) {
}

/**
 *
 */
WordPattern::GroupElement::GroupElement(const WordPattern &element) :
  Element(element) {
}

/**
 *
 */
WordPattern::AndGroupElement::AndGroupElement(const WordPattern &element) :
  GroupElement(element) {
}

/**
 *
 */
WordPattern::OrGroupElement::OrGroupElement(const WordPattern &element) :
  GroupElement(element) {
}

/**
 *
 */
WordPattern::LeafElement::LeafElement(const WordPattern &element) :
  Element(element),
  d_pos(NULL),
  d_feature(NULL) {
}

/**
 *
 */
WordPattern::Element::Element(const Element &o) :
  d_element(o.d_element),
  d_negative(o.d_negative) {
}

/**
 *
 */
WordPattern::GroupElement::GroupElement(const GroupElement &o) :
  Element(o) {
  {for (ElementIterator it = o.elementsBegin(); it != o.elementsEnd(); ++it) {
    d_elements.push_back((*it)->clone());
  }}
}

/**
 *
 */
WordPattern::OrGroupElement::OrGroupElement(const OrGroupElement &o) :
  GroupElement(o) {
}

/**
 *
 */
WordPattern::AndGroupElement::AndGroupElement(const AndGroupElement &o) :
  GroupElement(o) {
}

/**
 *
 */
WordPattern::LeafElement::LeafElement(const LeafElement &o) :
  Element(o),
  d_pos(o.d_pos),
  d_feature(o.d_feature),
  d_form(o.d_form),
  d_lemma(o.d_lemma) {
}

/**
 *
 */
WordPattern::Element *WordPattern::OrGroupElement::clone() const {
  return new OrGroupElement(*this);
}

/**
 *
 */
WordPattern::Element *WordPattern::AndGroupElement::clone() const {
  return new AndGroupElement(*this);
}

/**
 *
 */
WordPattern::Element *WordPattern::LeafElement::clone() const {
  return new LeafElement(*this);
}

/**
 *
 */
WordPattern::Element::~Element() {
}

/**
 *
 */
WordPattern::GroupElement::~GroupElement() {
  {for (ElementIterator it = d_elements.begin();
	it != d_elements.end(); ++it) {
    delete *it;
  }}
}

/**
 *
 */
WordPattern::OrGroupElement::~OrGroupElement() {
}

/**
 *
 */
WordPattern::AndGroupElement::~AndGroupElement() {
}

/**
 *
 */
WordPattern::LeafElement::~LeafElement() {
}

/**
 *
 */
const WordPattern &WordPattern::Element::getElement() const {
  return d_element;
}

/**
 *
 */
WordPattern::GroupElement::ElementIterator
WordPattern::GroupElement::elementsBegin() const {
  return d_elements.begin();
}

/**
 *
 */
WordPattern::GroupElement::ElementIterator
WordPattern::GroupElement::elementsEnd() const {
  return d_elements.end();
}

/**
 *
 */
bool
WordPattern::LeafElement::matches(const LingFeatures &features) const {
  if (d_feature != NULL) {
    if (!features.has(*d_feature)) {
      return isNegative();
    }
  } else {
    if (d_pos != NULL && features.getPosDef() != d_pos) {
      return isNegative();
    }
  }

  if (d_lemma != "" && features.getLemma() != d_lemma) {
    return isNegative();
  }

  if (d_form != "" && features.getForm() != d_form) {
    return isNegative();
  }

  return !isNegative();
}

/**
 *
 */
bool
WordPattern::AndGroupElement::matches(const LingFeatures &features) const {
  {for (ElementIterator it = elementsBegin(); it != elementsEnd(); ++it) {
    if (!(*it)->matches(features)) {
      return isNegative();
    }
  }}
  return !isNegative();
}

/**
 *
 */
bool
WordPattern::OrGroupElement::matches(const LingFeatures &features) const {
  {for (ElementIterator it = elementsBegin(); it != elementsEnd(); ++it) {
    if ((*it)->matches(features)) {
      return !isNegative();
    }
  }}
  return isNegative();
}

/**
 *
 */
void WordPattern::LeafElement::generate(vector<const LingFeatures *> &v,
					LingFeatures *current)
  const {

  if (isNegative()) {
    // What to do?
    return;
  }

  if (current == NULL) {
    const LingDef::Pos *posDef = d_pos;
    if (posDef == NULL && d_feature != NULL) {
      posDef = d_feature->getPosDef();
    }
    if (posDef != NULL) {
      current = new LingFeatures(*posDef);
      v.push_back(current);
    }
  }

  if (current != NULL && d_feature != NULL) {
    current->set(*d_feature);
  }
}

/**
 *
 */
void WordPattern::OrGroupElement::generate(vector<const LingFeatures *> &v,
					   LingFeatures *current)
  const {
  {for (ElementIterator it = elementsBegin(); it != elementsEnd(); ++it) {
    (*it)->generate(v, current);
  }}  
}

/**
 *
 */
void WordPattern::AndGroupElement::generate(vector<const LingFeatures *> &v,
					    LingFeatures *current)
  const {
  {for (ElementIterator it = elementsBegin(); it != elementsEnd(); ++it) {
    (*it)->generate(v, current);
  }}  
}

/**
 *
 */
void WordPattern::LeafElement::setPosDef(const LingDef::Pos &val) {
  d_pos = &val;
}

/**
 *
 */
const LingDef::Pos *WordPattern::LeafElement::getPosDef() const {
  return d_pos;
}

/**
 *
 */
void WordPattern::LeafElement::setForm(const string &val) {
  d_form = val;
}

/**
 *
 */
void WordPattern::LeafElement::setLemma(const string &val) {
  d_lemma = val;
}

/**
 *
 */
void WordPattern::LeafElement::setFeature(const LingDef::Feature &val) {
  d_feature = &val;
}

/**
 *
 */
void
WordPattern::LeafElement::setFeature(const LingDef::Feature &enumFeat,
				     const LingDef::Feature &enumValFeat) {
  if (enumValFeat.getParentEnum() != &enumFeat) {
    //ERROR
    return;
  }

  d_feature = &enumValFeat;
}

/**
 *
 */
WordPattern::AndGroupElement &WordPattern::GroupElement::createAnd() {
  AndGroupElement *element = new AndGroupElement(getElement());
  d_elements.push_back(element);
  return *element;
}

/**
 *
 */
WordPattern::OrGroupElement &WordPattern::GroupElement::createOr() {
  OrGroupElement *element = new OrGroupElement(getElement());
  d_elements.push_back(element);
  return *element;
}

/**
 *
 */
WordPattern::LeafElement &WordPattern::GroupElement::createLeaf() {
  LeafElement *element = new LeafElement(getElement());
  d_elements.push_back(element);
  return *element;
}

/**
 *
 */
void WordPattern::Element::setNegative(bool val) {
  d_negative = val;
}

/**
 *
 */
bool WordPattern::Element::isNegative() const {
  return d_negative;
}

/**
 *
 */
WordPattern::Reference::Reference(const string &featureName,
				  int sourceElementIndex,
				  const string &sourceFeatureName) :
  d_featureName(featureName),
  d_sourceElementIndex(sourceElementIndex),
  d_sourceFeatureName(sourceFeatureName) {
}

/**
 *
 */
const string &WordPattern::Reference::getFeatureName() const {
  return d_featureName;
}

/**
 *
 */
int WordPattern::Reference::getSourceElementIndex() const {
  return d_sourceElementIndex;
}

/**
 *
 */
const string &WordPattern::Reference::getSourceFeatureName() const {
  return d_sourceFeatureName;
}

/**
 *
 */
WordPattern::Reference &
WordPattern::createReference(const string &featureName,
			     int sourceElementIndex,
			     const string &sourceFeatureName) {
  Reference *newReference = new Reference(featureName,
					  sourceElementIndex,
					  sourceFeatureName);
  d_references.push_back(newReference);
  return *newReference;
}

/**
 *
 */
WordPattern::ReferenceIterator
WordPattern::referencesBegin() const {
  return d_references.begin();
}

/**
 *
 */
WordPattern::ReferenceIterator
WordPattern::referencesEnd() const {
  return d_references.end();
}
