#ifndef _LINGUISTICDEFINITION_SENTENCEPATTERN_H_
#define _LINGUISTICDEFINITION_SENTENCEPATTERN_H_

#include <string>
#include <vector>
#include <set>

#include "LingDef.h"
#include "LingFeaturesSet.h"
#include "WordPattern.h"

//TODO: matching in own class?
//TODO: references! allow in or's or what? how does it map to transfer rules?

namespace LinguisticDefinition {

  /**
   *
   */
  class SentencePattern {
  public:

    /**
     *
     */
    SentencePattern();

    /**
     *
     */
    ~SentencePattern();

    /**
     *
     */
    SentencePattern(const SentencePattern &);

    /**
     *
     */
    bool hasEndOperator() const;

    /**
     *
     */
    bool hasBeginningOperator() const;

    /**
     *
     */
    void setEndOperator(bool = true);

    /**
     *
     */
    void setBeginningOperator(bool = true);

    /**
     *
     */
    class Element {
      friend class SentencePattern;
    public:

      /**
       *
       */
      Element(const SentencePattern &, int listPosition);

      /**
       *
       */
      const SentencePattern &getSentencePattern() const;

      /**
       *
       */
      const WordPattern &getWordPattern() const;

      /**
       *
       */
      const WordPattern &getHeadPattern() const;

      /**
       *
       */
      WordPattern &getModifiableWordPattern();

      /**
       *
       */
      WordPattern &getModifiableHeadPattern();

      /**
       *
       */
      bool hasHeadPattern() const;

      /**
       *
       */
      int getMinimumLoopCount() const;

      /**
       *
       */
      int getMaximumLoopCount() const;

      /**
       *
       */
      bool hasOnlyOperator() const;

      /**
       *
       */
      bool isWildcard() const;

      /**
       *
       */
      void setMinimumLoopCount(int);

      /**
       *
       */
      void setMaximumLoopCount(int);

      /**
       *
       */
      void setOnlyOperator(bool = true);

      /**
       *
       */
      const Element *getNext() const;

      /**
       *
       */
      const Element *getPrevious() const;

      /**
       * First is 1
       */
      int getPatternPosition() const;
      
    private:
      const SentencePattern *d_parent;
      int d_listPosition;

      WordPattern d_wordPattern;
      WordPattern d_headPattern;

      int d_loopMin;
      int d_loopMax;
      bool d_hasOnlyOperator;
    };

    /**
     *
     */
    Element &createElement();

    /**
     *
     */
    typedef std::vector<const Element *> ElementList;
    typedef ElementList::const_iterator ElementIterator;

    /**
     *
     */
    ElementIterator elementsBegin() const;

    /**
     *
     */
    ElementIterator elementsEnd() const;

    /**
     * First is 1
     */
    const Element *getElementAtPosition(int) const;

  private:
    ElementList d_elements;
    bool d_hasBeginningOperator;
    bool d_hasEndOperator;
  };

}

#endif //_LINGUISTICDEFINITION_SENTENCEPATTERN_H_
