#include "LinguisticDefinition/SentencePattern.h"

using namespace std;
using namespace LinguisticDefinition;

/**
 *
 */
SentencePattern::SentencePattern() :
  d_hasBeginningOperator(false),
  d_hasEndOperator(false) {
}

/**
 *
 */
SentencePattern::~SentencePattern() {
  {for (ElementIterator it = elementsBegin(); it != elementsEnd(); ++it) {
    delete *it;
  }}
}

/**
 *
 */
SentencePattern::SentencePattern(const SentencePattern &o) :
  d_hasBeginningOperator(o.d_hasBeginningOperator),
  d_hasEndOperator(o.d_hasEndOperator) {
  {for (ElementIterator it = o.elementsBegin(); it != o.elementsEnd(); ++it) {
    Element *element = new Element(**it);
    element->d_parent = this;
    d_elements.push_back(element);
  }}
}

/**
 *
 */
bool SentencePattern::hasEndOperator() const {
  return d_hasEndOperator;
}

/**
 *
 */
bool SentencePattern::hasBeginningOperator() const {
  return d_hasBeginningOperator;
}

/**
 *
 */
void SentencePattern::setEndOperator(bool val) {
  d_hasEndOperator = val;
}

/**
 *
 */
void SentencePattern::setBeginningOperator(bool val) {
  d_hasBeginningOperator = val;
}

/**
 *
 */
SentencePattern::ElementIterator SentencePattern::elementsBegin() const {
  return d_elements.begin();
}

/**
 *
 */
SentencePattern::ElementIterator SentencePattern::elementsEnd() const {
  return d_elements.end();
}

/**
 *
 */
SentencePattern::Element &SentencePattern::createElement() {
  Element *element = new Element(*this, d_elements.size() + 1);
  d_elements.push_back(element);
  return *element;
}

/**
 *
 */
const SentencePattern::Element *
SentencePattern::getElementAtPosition(int index) const {
  if (1 <= index && index <= (int) d_elements.size()) {
    return d_elements[index - 1];
  }
  return NULL;
}

/**
 *
 */
SentencePattern::Element::Element(const SentencePattern &parent,
				  int listPosition) :
  d_parent(&parent),
  d_listPosition(listPosition),
  d_loopMin(1),
  d_loopMax(1),
  d_hasOnlyOperator(false) {
}

/**
 *
 */
const SentencePattern &SentencePattern::Element::getSentencePattern() const {
  return *d_parent;
}

/**
 *
 */
const WordPattern &SentencePattern::Element::getWordPattern() const {
  return d_wordPattern;
}

/**
 *
 */
const WordPattern &SentencePattern::Element::getHeadPattern() const {
  return d_headPattern;
}

/**
 *
 */
WordPattern &SentencePattern::Element::getModifiableWordPattern() {
  return d_wordPattern;
}

/**
 *
 */
WordPattern &SentencePattern::Element::getModifiableHeadPattern() {
  return d_headPattern;
}

/**
 *
 */
bool SentencePattern::Element::hasHeadPattern() const {
  return
    d_headPattern.getRootElement().elementsBegin() !=
    d_headPattern.getRootElement().elementsEnd();
}

/**
 *
 */
int SentencePattern::Element::getMinimumLoopCount() const {
  return d_loopMin;
}

/**
 *
 */
int SentencePattern::Element::getMaximumLoopCount() const {
  return d_loopMax;
}

/**
 *
 */
bool SentencePattern::Element::hasOnlyOperator() const {
  return d_hasOnlyOperator;
}

/**
 *
 */
bool SentencePattern::Element::isWildcard() const {
  // No matching information means that it is a wildcard
  const WordPattern::GroupElement &wordElement =
    d_wordPattern.getRootElement();
  return wordElement.elementsBegin() == wordElement.elementsEnd();
}

/**
 *
 */
void SentencePattern::Element::setMinimumLoopCount(int val) {
  d_loopMin = val;
}

/**
 *
 */
void SentencePattern::Element::setMaximumLoopCount(int val) {
  d_loopMax = val;
}

/**
 *
 */
void SentencePattern::Element::setOnlyOperator(bool val) {
  d_hasOnlyOperator = val;
}

/**
 *
 */
const SentencePattern::Element *SentencePattern::Element::getNext() const {
  return d_parent->getElementAtPosition(d_listPosition + 1);
}

/**
 *
 */
const SentencePattern::Element *SentencePattern::Element::getPrevious() const {
  return d_parent->getElementAtPosition(d_listPosition - 1);
}

/**
 *
 */
int SentencePattern::Element::getPatternPosition() const {
  return d_listPosition;
}
