#include "LinguisticDefinition/LingFeaturesSet.h"

using namespace std;
using namespace LinguisticDefinition;

//TODO: identity stuff? it would fix double entries

/**
 *
 */
LingFeaturesSet::LingFeaturesSet() :
  d_lingDef(NULL),
  d_posDef(NULL),
  d_sharedPosDef(true) {
}

/**
 *
 */
LingFeaturesSet::~LingFeaturesSet() {
  {for (ElementIterator it = d_elements.begin();
	it != d_elements.end(); ++it) {
    delete *it;
  }}
  {for (ElementIterator it = d_removedElements.begin();
	it != d_removedElements.end(); ++it) {
    delete *it;
  }}
}

/**
 *
 */
void LingFeaturesSet::add(const LingFeatures &element) {
  if (d_lingDef == NULL) {
    d_lingDef = element.getLingDef();
  } else if (d_lingDef != element.getLingDef()) {
    d_sharedPosDef = false;
  }

  if (d_sharedPosDef && d_posDef == NULL) {
    d_posDef = element.getPosDef();
  } else if (d_sharedPosDef && d_posDef != element.getPosDef()) {
    d_sharedPosDef = false;
  }

  d_elements.insert(new LingFeatures(element));
}

/**
 *
 */
bool LingFeaturesSet::isEmpty() const {
  return d_elements.empty();
}

/**
 *
 */
void LingFeaturesSet::set(const string &feature) {
  const LingDef::Feature *featureDef = NULL;
  if (d_sharedPosDef && d_posDef != NULL) {
    // We can look up the feature definition
    featureDef = d_posDef->getFeature(feature);
  }

  if (featureDef != NULL) {
    set(*featureDef);
  } else {

    // We have to look up each one individually
    // (the copying thing won't work)
    cerr << "Warning: unable to look up '" << feature << "'" << endl;
    {for (ElementIterator it = d_elements.begin();
	  it != d_elements.end(); ++it) {
      (*it)->set(feature);
    }}
  }
}

/**
 *
 */
void LingFeaturesSet::set(const LingDef::Feature &feature) {
  const LingDef::Feature *enumFeature = feature.getParentEnum();

  //TODO: should booleans also cause copying?

  if (enumFeature != NULL && !enumFeature->allowSeveralValues()) {

    // Copy each LingFeatures object, and the the feature
    ElementSet elementsCopy(d_elements);
    {for (ElementIterator it = elementsCopy.begin();
	  it != elementsCopy.end(); ++it) {
      if (!(*it)->has(*enumFeature)) {
	LingFeatures *newFeatures = new LingFeatures(**it);
	newFeatures->set(feature);
	d_elements.insert(newFeatures);
      }
    }}

  } else {
    // Set the feature for each element
    {for (ElementSet::iterator it = d_elements.begin();
	  it != d_elements.end(); ++it) {
      (*it)->set(feature);
    }}
  }
}

/**
 *
 */
bool LingFeaturesSet::has(const string &feature) const {
  if (d_sharedPosDef && d_posDef != NULL) {
    // We can look up the feature definition
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef == NULL) {
      return false;
    }
    return has(*featureDef);
  }

  // We have to look up each one individually
  cerr << "Warning: '" << feature << "' not shared pos" << endl;
  {for (ElementIterator it = d_elements.begin();
	it != d_elements.end(); ++it) {
    if ((*it)->has(feature)) {
      return true;
    }
  }}
  return false;
}

/**
 *
 */
bool LingFeaturesSet::has(const LingDef::Feature &feature) const {
  {for (ElementIterator it = d_elements.begin();
	it != d_elements.end(); ++it) {
    if ((*it)->has(feature)) {
      return true;
    }
  }}
  return false;
}

/**
 *
 */
void LingFeaturesSet::setEnum(const string &enumFeature,
			      const string &valueFeature) {
  if (d_sharedPosDef && d_posDef != NULL) {
    const LingDef::Feature *enumFeatureDef = d_posDef->getFeature(enumFeature);
    if (enumFeatureDef != NULL) {
      const LingDef::Feature *valueFeatureDef =
	d_posDef->getFeature(valueFeature);

      if (valueFeatureDef != NULL) {
	setEnum(*enumFeatureDef, *valueFeatureDef);
      }
    }
  } else {
    //TODO
  }
}

/**
 *
 */
void LingFeaturesSet::setEnum(const LingDef::Feature &enumFeature,
			      const LingDef::Feature &valueFeature) {
  if (valueFeature.getParentEnum() == &enumFeature) {
    set(valueFeature);
  }
}

/**
 *
 */
void LingFeaturesSet::getEnumValues(const string &enumFeature,
				    std::set<const LingDef::Feature *> &result)
  const {
  if (d_sharedPosDef && d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(enumFeature);
    if (featureDef != NULL) {
      getEnumValues(*featureDef, result);
    }
  } else {
    //TODO
  }
}

/**
 *
 */
void LingFeaturesSet::getEnumValues(const LingDef::Feature &enumFeature,
				    std::set<const LingDef::Feature *> &result)
  const {
  {for (ElementIterator it = d_elements.begin();
	it != d_elements.end(); ++it) {
    (*it)->getEnumValues(enumFeature, result);
  }}
}

/**
 *
 */
LingFeaturesSet::ElementIterator LingFeaturesSet::elementsBegin() const {
  return d_elements.begin();
}

/**
 *
 */
LingFeaturesSet::ElementIterator LingFeaturesSet::elementsEnd() const {
  return d_elements.end();
}
