#ifndef _LINGUISTICDEFINITION_LINGFEATURESFORMATTER_H_
#define _LINGUISTICDEFINITION_LINGFEATURESFORMATTER_H_

#include <string>
#include <iostream>

#include "LinguisticDefinition/LingDef.h"
#include "LinguisticDefinition/LingFeatures.h"
#include "LinguisticDefinition/Formatter.h"

namespace LinguisticDefinition {

  /**
   *
   */
  class LingFeaturesFormatter : public Formatter {
  public:

    /**
     *
     */
    LingFeaturesFormatter(const LingDef &);

    /**
     *
     */
    const LingDef &getLingDef() const;

    /**
     *
     */
    virtual std::string output(const LingFeatures &) const = 0;

    /**
     *
     */
    virtual void output(const LingFeatures &, std::ostream &) const = 0;

  private:
    const LingDef &d_lingDef;
  };

}

#endif //_LINGUISTICDEFINITION_LINGFEATURESFORMATTER_H_
