#include "LinguisticDefinition/LingFeatures.h"

using namespace std;
using namespace LinguisticDefinition;

/**
 *
 */
LingFeatures::LingFeatures() :
  d_lingDef(NULL),
  d_posDef(NULL) {
}

/**
 *
 */
LingFeatures::~LingFeatures() {
}

/**
 *Temporary
 */
LingFeatures::LingFeatures(const LingDef &lingDef) :
  d_lingDef(&lingDef),
  d_posDef(NULL) {
}

/**
 *
 */
LingFeatures::LingFeatures(const LingDef::Pos &pos) :
  d_lingDef(pos.getLingDef()),
  d_posDef(&pos) {
  setDefaults();
}

/**
 *
 */
const LingDef *LingFeatures::getLingDef() const {
  return d_lingDef;
}

/**
 *
 */
const LingDef::Pos *LingFeatures::getPosDef() const {
  return d_posDef;
}

/**
 *
 */
void LingFeatures::setPosDef(const LingDef::Pos &pos) {
  d_posDef = &pos;
  setDefaults();
}

/**
 *
 */
void LingFeatures::execute(const std::string &expr) {
  // Make copy
  string expression = expr;
  string::size_type expressionLength = expression.length();

  if (expressionLength > 0) {
    string::size_type fieldBeginIndex = 0;
    bool inFieldName = false;
    bool positive = false;

    {for (string::size_type index = 0; index < expressionLength; index++) {
      char c = expression[index];
	
      if (!inFieldName) {
	if (c == '+') {
	  positive = true;
	  inFieldName = true;
	} else if (c == '-') {
	  positive = false;
	  inFieldName = true;
	}
	if (inFieldName) {
	  fieldBeginIndex = index + 1;
	}
      } else {
	if (('a' <= c && c <= 'z') ||
	    ('A' <= c && c <= 'Z') ||
	    ('0' <= c && c <= '9') ||
	    c == '_' ||
	    c == '=' ||
	    c == '$' ||
	    c == '.') {
	  if (index == expressionLength - 1) {
	    index++;
	    inFieldName = false;
	  }
	} else {
	  index--;
	  inFieldName = false;
	}
	if (!inFieldName) {
	  string fieldValue = expression.substr(fieldBeginIndex,
						index + 1 - fieldBeginIndex);
	  string::size_type equalsIndex = fieldValue.find('=');
	  if (equalsIndex != string::npos) {
	    string equalsValue = fieldValue.substr(equalsIndex + 1);
	    fieldValue = fieldValue.substr(0, equalsIndex);

	    if (equalsValue.length() > 1 && equalsValue[0] == '$') {
	      string::size_type dotIndex = equalsValue.find('.');

	      if (dotIndex != string::npos) {
		string referenceTarget = equalsValue.substr(1, dotIndex - 1);
		string referenceEnum = equalsValue.substr(dotIndex + 1);

		//TODO: how to integrate? only matching...

	      } else {
		string referenceTarget = equalsValue.substr(1);
		int referenceTargetInt = atoi(referenceTarget.c_str());
		setReference(fieldValue, referenceTargetInt);
	      }
		
	    } else {
	      if (positive) {
		set(equalsValue);
	      } else {
		setNegative(equalsValue);
	      }
	    }
	      
	  } else {
	    if (positive) {
	      set(fieldValue);
	    } else {
	      setNegative(fieldValue);
	    }
	  }
	}
      }
    }}
  }
}

/**
 *
 */
void LingFeatures::set(const LingDef::Feature &feature) {
//   if (feature.getType() == LingDef::Feature::BOOLEAN) {
    return setSub(feature);
//   }
}

/**
 *
 */
void LingFeatures::setNegative(const LingDef::Feature &feature) {
  unset(feature);
  d_negativeFeatures.insert(&feature);
}

/**
 *
 */
void LingFeatures::unset(const LingDef::Feature &feature) {
  return unsetSub(feature);
}

/**
 *
 */
void LingFeatures::setSub(const LingDef::Feature &feature) {
  if (has(feature)) {
    // In the case of vtree, add anyway
    d_features.insert(&feature);

  } else { 
    d_features.insert(&feature);
    d_negativeFeatures.erase(&feature);

    if (feature.getType() == LingDef::Feature::ENUM) {
      setDefaultForEnum(feature);
    }

    const LingDef::Feature *parentEnum = feature.getParentEnum();
    if (parentEnum != NULL) {

      if (!parentEnum->allowSeveralValues()) {
	// Must remove any old enum values for this feature
	d_enums.erase(parentEnum);
      }

      pair<const LingDef::Feature *, const LingDef::Feature *> p(parentEnum,
								 &feature);
      d_enums.insert(p);

      if (!has(*parentEnum)) {
	d_features.insert(parentEnum);

      } else if (!parentEnum->allowSeveralValues()) {
	{for (LingDef::Feature::EnumChildrenIterator
		it = parentEnum->enumChildrenBegin();
	      it != parentEnum->enumChildrenEnd(); ++it) {
	  if (*it != &feature) {
	    const LingDef::Feature *siblingFeature = *it;
	    d_features.erase(siblingFeature);
	  }
	}}
      }

      // Unset conflicting features
      if (d_lingDef != NULL) {
	const LingDef::Pos::FeatureList *conflicts =
	  d_lingDef->getConflicts(*parentEnum);
	if (conflicts != NULL) {
	  {for (LingDef::Pos::FeatureIterator it = conflicts->begin();
		it != conflicts->end(); ++it) {
	    unset(**it);
	  }}
	}
      }

    }

    // Unset conflicting features
    if (d_lingDef != NULL) {
      const LingDef::Pos::FeatureList *conflicts =
	d_lingDef->getConflicts(feature);
      if (conflicts != NULL) {
	{for (LingDef::Pos::FeatureIterator it = conflicts->begin();
	      it != conflicts->end(); ++it) {
	  unset(**it);
	}}
      }
    }
  }
}

/**
 *
 */
void LingFeatures::unsetSub(const LingDef::Feature &feature) {
  d_negativeFeatures.erase(&feature);

  if (has(feature)) {
    d_features.erase(&feature);

    const LingDef::Feature *enumFeature = NULL;
    if (feature.getParentEnum() != NULL) {
      enumFeature = feature.getParentEnum();
    } else if (feature.getType() == LingDef::Feature::ENUM) {
      enumFeature = &feature;
    } else if (feature.getType() == LingDef::Feature::REFERENCE) {
      d_references.erase(&feature);
    }
    //TODO: vtree?

    if (enumFeature != NULL) {

      if (!enumFeature->allowSeveralValues()) {
	d_features.erase(enumFeature);
	d_enums.erase(enumFeature);

	{for (LingDef::Feature::EnumChildrenIterator
		it = enumFeature->enumChildrenBegin();
	      it != enumFeature->enumChildrenEnd(); ++it) {
	  const LingDef::Feature *siblingFeature = *it;
	  d_features.erase(siblingFeature);
	}}

	if (!enumFeature->allowNoValue()) {
	  setDefaultForEnum(*enumFeature);
	}

      } else {
	{for (multimap<const LingDef::Feature *, const LingDef::Feature *>::
		iterator it = d_enums.find(enumFeature);
	      it != d_enums.end() && (*it).first == enumFeature; ) {
	  const LingDef::Feature *f = (*it).second;
	  multimap<const LingDef::Feature *, const LingDef::Feature *>::
	    iterator prevIt = it;
	  ++it;
	  if (f == &feature || &feature == enumFeature) {
	    d_enums.erase(prevIt);
	    if (&feature == enumFeature) {
	      d_features.erase(f);
	    }
	  }
	}}
      
	if (d_enums.find(enumFeature) == d_enums.end()) {
	  // There was not enum value left
	  d_features.erase(enumFeature);
	  if (!enumFeature->allowNoValue()) {
	    setDefaultForEnum(*enumFeature);
	  }
	}
      }

    } else {
      const LingDef::Tree *tree = feature.getTree();
      if (tree != NULL) {
	//TODO: unset for this tree?
      }
    }
  }
}

/**
 *
 */
bool LingFeatures::has(const LingDef::Feature &feature) const {
  return feature.isIn(d_features);
}

/**
 *
 */
bool LingFeatures::hasNegative(const LingDef::Feature &feature) const {
  return d_negativeFeatures.find(&feature) != d_negativeFeatures.end();
}

/**
 *
 */
bool LingFeatures::isDefined(const LingDef::Feature &feature) const {
  return hasNegative(feature) || has(feature);
}

/**
 *
 */
void LingFeatures::set(const string &feature) {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef != NULL) {
      return set(*featureDef);
    }
  }
}

/**
 *
 */
void LingFeatures::setNegative(const string &feature) {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef != NULL) {
      return setNegative(*featureDef);
    }
  }
}

/**
 *
 */
void LingFeatures::unset(const string &feature) {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef != NULL) {
      return unset(*featureDef);
    }
  }
}

/**
 *
 */
void LingFeatures::setReference(const string &feature, int referenceValue) {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef != NULL) {
      return setReference(*featureDef, referenceValue);
    }
  }
}

/**
 *
 */
int LingFeatures::getReference(const string &feature) const {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef != NULL) {
      return getReference(*featureDef);
    }
  }
  return 0;
}

/**
 *
 */
void LingFeatures::getReferenceList(const string &feature,
				    vector<int> &results) const {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef != NULL) {
      getReferenceList(*featureDef, results);
    }
  }
}

/**
 *
 */
bool LingFeatures::hasReference(const string &feature,
				int referenceValue) const {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef != NULL) {
      return hasReference(*featureDef, referenceValue);
    }
  }
  return false;
}

/**
 *
 */
void LingFeatures::setReference(const LingDef::Feature &feature,
				int referenceValue) {
  if (!feature.allowSeveralValues()) {
    // Must remove any old references for this feature
    d_references.erase(&feature);
  }
  d_references.insert(pair<const LingDef::Feature *, int>(&feature,
							  referenceValue));
  setSub(feature);
}

/**
 *
 */
int LingFeatures::getReference(const LingDef::Feature &feature) const {
  multimap<const LingDef::Feature *, int>::const_iterator
    findIt = d_references.find(&feature);
  if (findIt != d_references.end()) {
    return (*findIt).second;
  }
  return 0;
}

/**
 *
 */
void LingFeatures::getReferenceList(const LingDef::Feature &feature,
				    vector<int> &results) const {
  {for (multimap<const LingDef::Feature *, int>::const_iterator
	  it = d_references.find(&feature);
	it != d_references.end() && (*it).first == &feature; ++it) {
    results.push_back((*it).second);
  }}
}

/**
 *
 */
bool LingFeatures::hasReference(const LingDef::Feature &feature,
				int referenceValue) const {
  {for (multimap<const LingDef::Feature *, int>::const_iterator
	  it = d_references.find(&feature);
	it != d_references.end() && (*it).first == &feature; ++it) {
    if ((*it).second == referenceValue) {
      return true;
    }
  }}
  return false;
}

/**
 *
 */
void LingFeatures::setEnum(const string &enumFeature,
			   const string &valueFeature) {
  if (d_posDef != NULL) {
    const LingDef::Feature *enumFeatureDef = d_posDef->getFeature(enumFeature);
    if (enumFeatureDef != NULL) {
      const LingDef::Feature *valueFeatureDef =
	d_posDef->getFeature(valueFeature);

      if (valueFeatureDef != NULL) {
	setEnum(*enumFeatureDef, *valueFeatureDef);
      }
    }
  }
}

/**
 *
 */
void LingFeatures::setEnum(const LingDef::Feature &enumFeature,
			   const LingDef::Feature &valueFeature) {
  if (valueFeature.getParentEnum() == &enumFeature) {
    set(valueFeature);
  }
}

/**
 *
 */
const LingDef::Feature *
LingFeatures::getEnumValue(const string &enumFeature) const {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(enumFeature);
    if (featureDef != NULL) {
      return getEnumValue(*featureDef);
    }
  }
  return NULL;
}

/**
 *
 */
const LingDef::Feature *
LingFeatures::getEnumValue(const LingDef::Feature &enumFeature) const {
  //TODO: warn if several
  multimap<const LingDef::Feature *, const LingDef::Feature *>::const_iterator
    findIt = d_enums.find(&enumFeature);
  if (findIt != d_enums.end()) {
    return (*findIt).second;
  }
  return NULL;
}

/**
 *
 */
void LingFeatures::getEnumValues(const string &enumFeature,
				 std::set<const LingDef::Feature *> &results)
  const {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(enumFeature);
    if (featureDef != NULL) {
      getEnumValues(*featureDef, results);
    }
  }
}

/**
 *
 */
void LingFeatures::getEnumValues(const LingDef::Feature &enumFeature,
				 std::set<const LingDef::Feature *> &results)
  const {
  {for (multimap<const LingDef::Feature *, const LingDef::Feature *>::
	  const_iterator it = d_enums.find(&enumFeature);
	it != d_enums.end() && (*it).first == &enumFeature; ++it) {
    results.insert((*it).second);
  }}
}

/**
 * @return 0 for false, 1 for only this value, 2 for this among others
 */
int LingFeatures::hasEnumValue(const std::string &enumValueName) const {
  if (d_posDef != NULL) {
    const LingDef::Feature *enumValueDef = d_posDef->getFeature(enumValueName);
    if (enumValueDef != NULL) {
      return hasEnumValue(*enumValueDef);
    }
  }
  return 0;
}

/**
 * @return 0 for false, 1 for only this value, 2 for this among others
 */
int LingFeatures::hasEnumValue(const LingDef::Feature &enumValueFeature)
  const {
  const LingDef::Feature *parentEnum = enumValueFeature.getParentEnum();

  if (parentEnum != NULL && has(enumValueFeature)) {
    std::set<const LingDef::Feature *> enumValues;
    getEnumValues(*parentEnum, enumValues);
    if (enumValues.size() > 1) {
      return 2;
    }
    return 1;
  }

  return 0;
}

/**
 *
 */
bool LingFeatures::has(const string &feature) const {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef != NULL) {
      return has(*featureDef);
    }
  }
  return false;
}

/**
 *
 */
bool LingFeatures::hasNegative(const std::string &feature) const {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef != NULL) {
      return hasNegative(*featureDef);
    }
  }
  return false;
}

/**
 *
 */
bool LingFeatures::isDefined(const std::string &feature) const {
  if (d_posDef != NULL) {
    const LingDef::Feature *featureDef = d_posDef->getFeature(feature);
    if (featureDef != NULL) {
      return isDefined(*featureDef);
    }
  }
  return false;
}

/**
 *
 */
const LingFeatures &LingFeatures::operator+=(const std::string &feature) {
  set(feature);
  return *this;
}

/**
 *
 */
const LingFeatures &LingFeatures::operator+=(const LingDef::Feature &feature) {
  set(feature);
  return *this;
}

/**
 *
 */
const LingFeatures &LingFeatures::operator-=(const std::string &feature) {
  setNegative(feature);
  return *this;
}

/**
 *
 */
const LingFeatures &LingFeatures::operator-=(const LingDef::Feature &feature) {
  setNegative(feature);
  return *this;
}

/**
 *
 */
bool LingFeatures::covers(const LingFeatures &other) const {
  if (d_posDef != other.d_posDef) {
    return false;
  }

  // The other LingFeatures must have all features to be covered
  {for (std::set<const LingDef::Feature *>::const_iterator
	  it = d_features.begin();
	it != d_features.end(); ++it) {
    const LingDef::Feature *feature = *it;
    if (!other.has(*feature)) {
      return false;
    }
  }}

  return true;
}

/**
 *
 */
LingFeatures::FeatureIterator LingFeatures::featuresBegin() const {
  return d_features.begin();
}

/**
 *
 */
LingFeatures::FeatureIterator LingFeatures::featuresEnd() const {
  return d_features.end();
}

/**
 *
 */
void LingFeatures::setDefaultForEnum(const LingDef::Feature &enumFeature) {
  {for (LingDef::Feature::EnumChildrenIterator
	  it = enumFeature.enumChildrenBegin();
	it != enumFeature.enumChildrenEnd(); ++it) {
    const LingDef::Feature *enumValueFeature = *it;
    if (enumValueFeature->isDefault()) {
      set(*enumValueFeature);
      return;
    }
  }}
}

/**
 *
 */
void LingFeatures::setDefaults() {
  const LingDef::Pos *posDef = d_posDef;
  while (posDef != NULL) {
    {for (LingDef::Pos::FeatureIterator it = posDef->defaultFeaturesBegin();
	  it != posDef->defaultFeaturesEnd(); ++it) {
      const LingDef::Feature *feature = *it;
      set(*feature);
    }}
    posDef = posDef->getSuperPos();
  }
}

/**
 *
 */
const std::string &LingFeatures::getLemma() const {
  return d_lemma;
}

/**
 *
 */
void LingFeatures::setLemma(const std::string &val) {
  d_lemma = val;
}

/**
 *
 */
const std::string &LingFeatures::getForm() const {
  return d_form;
}

/**
 *
 */
void LingFeatures::setForm(const std::string &val) {
  d_form = val;
}
