#include <boost/filesystem/path.hpp>
#include <boost/lexical_cast.hpp>

#include <outilex/xml_text_chart.h>
#include <outilex/xml_format_chart.h>
#include <outilex/xml-names.h>

using namespace std;
using namespace boost;
using namespace xmlnames;
namespace fs = boost::filesystem;

void xml_ochart::open(const fs::path & path, int size, int compression) {
  
  close();
  
  size_ = size;

  writer.open(path, compression);
  writer.set_indent(1);
  
  writer.start_document();
  writer.start_element(TEXT_CHART_ELEM);

  if (size != -1) {
    writer.write_attribute(SIZE_ATTR, lexical_cast<string>(size));
  }
}

void xml_ochart::close() {
  if (writer) {
    writer.end_element(); // chart
    writer.end_document();
    writer.close();
  }
}

void xml_ochart::write(const wrtn_chart & chart) {
  wrtn_chart_write_xml(writer, chart);
}

