#include <string>

#include <outilex/wrtn_chart.h>

using namespace std;


wrtn_chart::match_by_val_iterator
wrtn_chart::find_best_match(int q, const string & syntname) const {

  /* create a match directly inferior (according to <) to the
   * first match of syntname in chart
   *
   * make it static to avoid constructing it again at each call.
   */
  static wrtn_match static_best_match("",
                                      numeric_limits<int>::max(),
                                      synt_path_type(),
                                      vector<string>(),
                                      numeric_limits<double>::max());
                        
  static_best_match.name = syntname;

  const wrtn_match & best_match = static_best_match;


  match_by_val_iterator res = tab[q].lower_bound(best_match);

  if (res != tab[q].val_end() && res->name != syntname) {
    res = tab[q].val_end();
  }
  return res;
}


// we don't have its index in the orig chart ...
// mais c'est ok car comme on traite les longest match en premier,
// on est sur que les prochains match traites dans keepit ne vont
// pas dependre de celui-ci (qui est au moins aussi long) n'est ce pas ?
// non c'est stupide ...
// ... nouvelle methode :
// pour detecter si un match a deja ete traite par keep_it,
// on met dans le champ q du premier element de son path,
// la valeur de son indice (negatif) dans la nvelle table
// (les path d'un match ont touhours au moins un element)

void wrtn_chart::keep_it(wrtn_match & m,
                         vector<node_type> & newtable) {

  int q0 = m.path[0].qno;
  if (q0 < 0) { // already proceed
    return;
  }

  for (synt_path_type::iterator it = m.path.begin(), end = m.path.end();
       it != end; ++it) {
    
    if (it->transno < 0) { // keep subtree

#warning "this is BAD"

      /* ATTENTION: on change la valeur des elements dans un set
       * comme on modifie les path uniquement,
       * ca ne devrait pas changer fondamentatlement l'ordre des matchs dans le set
       * mais c'est quand meme n'importe quoi
       */
      wrtn_match & subm = const_cast<wrtn_match&>(tab[it->qno][- it->transno - 1]);
      keep_it(subm, newtable);
      it->transno = subm.path[0].qno; // and remap to its new ids
    }
  }

  int idx = newtable[q0].add(m);
  m.path[0].qno = - idx - 1;
}


void wrtn_chart::cleanup(const string & syntname, bool longest_match) {

  int sz = size();
  vector<node_type> newtable(sz);


  // match directly < to the first 'syntname' match in chart

  const wrtn_match firstmatch(syntname, sz + 1,
                              synt_path_type(), vector<string>(), 
                              numeric_limits<double>::max());

  for (int q = 0; q < sz; ++q) {
  
    const node_type & node = tab[q];
    match_by_val_iterator first = node.lower_bound(firstmatch), end = node.val_end();

    while (first != end && first->name == syntname) {
      
      int to = first->to;
      double w = first->w;
 
      while (first != end && first->name == syntname
             && first->to == to) { // traverse match on the same segment
             
        if (w == first->w) { // and keep only the best by weight
#warning "this is BAD too"
          keep_it(const_cast<wrtn_match&>(*first), newtable);
        }
        ++first;  
      }
      if (longest_match) { break; }
    }
  }

  tab.swap(newtable);
}

