#include <iostream>
#include <fstream>
#include <stdexcept>
#include <sstream>
#include <vector>

#include <boost/lexical_cast.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>

#include <outilex/wrtn_grammar.h>
#include <outilex/fsa-determinize.h>
#include <outilex/usage.h>


using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

char * progname;


const char * USAGE_DESCRIPTION =
"usage: wrtn-flatten [-o opath] [-maxdepth <N>] <wrtn>\n";


int main(int argc, char ** argv) try {

  fs::path lingdefpath, rtnpath, opath;
  int maxdepth = numeric_limits<int>::max();

  char * text = getenv("LINGDEF");
  if (text) {
    lingdefpath = fs::path(text, fs::native);
  }


  argv++, argc--;
  if (argc == 0) { usage(); }

  while (argc) {
    
    string arg = *argv;
    
    if (arg == "-l") {
 
      argv++, argc--;
      if (argc == 0) { arg_needed(arg); }
      lingdefpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-o") {
      
      argv++, argc--;
      if (argc == 0) { arg_needed(arg); }
      opath = fs::path(*argv, fs::native);
 
    } else if (arg == "-rtn") {
      
      argv++, argc--;
      if (argc == 0) { arg_needed(arg); }
      rtnpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-depth") {

      argv++, argc--;
      if (argc == 0) { arg_needed(arg); }
      maxdepth = lexical_cast<int>(*argv);
 
    } else if (arg == "-h") {
    
      usage();
    
    } else {

      rtnpath = fs::path(arg, fs::native);
    }

    argv++, argc--;
  }

  if (lingdefpath.empty() || rtnpath.empty()) { bad_args(); }

  if (opath.empty()) { opath = rtnpath; }

  ling_def lingdef(lingdefpath);

  wrtn_grammar gram(rtnpath, & lingdef);

  cout << "flattening " << rtnpath.string() << "...\n";
  bool ok = flatten(gram, maxdepth);

#if 0
  cout << "determinization\n";
  fsa_determinize(gram.patterns[0]);
#endif
  gram.write(opath);


  cout << "done. result in " << opath.string() << ".\n";
  if (ok) {
    cout << "the resulting grammar is an equivalent FST ("
      << gram.patterns[0].size() << " states)\n";  
  } else {
    cout << "the resulting grammar is still an RTN.\n";
  }

  return 0;

} catch (exception & e) {

  cerr << "fatal error:" << e.what() << endl; exit(1);
}
