#ifndef _WRTN_PATTERN_H_
#define _WRTN_PATTERN_H_

#include <string>
#include <boost/filesystem/path.hpp>

#include <outilex/basic_fst.h>
#include <outilex/wrtn_input_type.h>
#include <outilex/wrtn_output_type.h>

class ling_def;
class generic_fst;

/**
 * @brief Class wrtn_pattern represents an automaton of a wrtn
 * */

class wrtn_pattern : public basic_fst<wrtn_input_type, wrtn_output_type> {

public:

  typedef basic_fst<wrtn_input_type, wrtn_output_type> fst_type;

  wrtn_pattern() : fst_type(), lingdef(0) {}
  wrtn_pattern(ling_def * ldef) : fst_type(), lingdef(ldef) {}

  wrtn_pattern(const generic_fst & fst, ling_def * ldef);

  wrtn_pattern(const boost::filesystem::path & path, ling_def * ldef);

  const std::string & get_name() const { return name; }

  void write(const boost::filesystem::path & path) const;
  void read(const boost::filesystem::path & path, ling_def * ldef);

  void read_xml(xmlNode * node, ling_def * ldef);
  void write_xml(xmlwriter & writer) const;

public:
  ling_def * lingdef;
  std::string name;
};


#endif
